/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.build;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.core.resources.builder.IBuilder;
import org.objectstyle.wolips.core.resources.builder.IFullBuilder;
import org.objectstyle.wolips.core.resources.internal.build.AbstractBuildVisitor;
import org.objectstyle.wolips.core.resources.internal.build.BuilderWrapper;

public class FullBuildDeltaVisitor
extends AbstractBuildVisitor
implements IResourceVisitor {
    public FullBuildDeltaVisitor(BuilderWrapper[] builderWrappers, IProgressMonitor _progressMonitor, Map _buildCache) {
        super(builderWrappers, _progressMonitor, _buildCache);
    }

    public boolean visit(IResource resource) throws CoreException {
        boolean visitChildren;
        if (resource == null || this.isCanceled()) {
            visitChildren = false;
        } else if (resource.isDerived()) {
            visitChildren = false;
        } else {
            visitChildren = true;
            Map buildCache = this.getBuildCache();
            IProgressMonitor progressMonitor = this.getProgressMonitor();
            int woResourceType = this.getWoResourceType(resource);
            if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_CLASS) {
                this.notifyBuilderHandleClasses(resource, progressMonitor, buildCache);
            } else if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_CLASSPATH) {
                this.notifyBuilderHandleOther(resource, progressMonitor, buildCache);
                this.notifyBuilderClasspath(resource, progressMonitor, buildCache);
            } else if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_IGNORE) {
                visitChildren = false;
            } else if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_OTHER) {
                this.notifyBuilderHandleOther(resource, progressMonitor, buildCache);
            } else if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_RESOURCE) {
                this.notifyBuilderHandleResources(resource, progressMonitor, buildCache);
            } else if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_SOURCE) {
                this.notifyBuilderHandleSource(resource, progressMonitor, buildCache);
            } else if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_WEB_SERVER_RESOURCE) {
                this.notifyBuilderHandleWebServerResources(resource, progressMonitor, buildCache);
            }
        }
        return visitChildren;
    }

    private void notifyBuilderClasspath(IResource resource, IProgressMonitor _progressMonitor, Map _buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IFullBuilder)) continue;
            ((IFullBuilder)builder).handleClasspath(resource, _progressMonitor, _buildCache);
        }
    }

    private void notifyBuilderHandleClasses(IResource resource, IProgressMonitor _progressMonitor, Map _buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IFullBuilder)) continue;
            ((IFullBuilder)builder).handleClasses(resource, _progressMonitor, _buildCache);
        }
    }

    private void notifyBuilderHandleSource(IResource resource, IProgressMonitor _progressMonitor, Map _buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IFullBuilder)) continue;
            ((IFullBuilder)builder).handleSource(resource, _progressMonitor, _buildCache);
        }
    }

    private void notifyBuilderHandleResources(IResource resource, IProgressMonitor _progressMonitor, Map _buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IFullBuilder)) continue;
            ((IFullBuilder)builder).handleWoappResources(resource, _progressMonitor, _buildCache);
        }
    }

    private void notifyBuilderHandleWebServerResources(IResource resource, IProgressMonitor _progressMonitor, Map _buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IFullBuilder)) continue;
            ((IFullBuilder)builder).handleWebServerResources(resource, _progressMonitor, _buildCache);
        }
    }

    private void notifyBuilderHandleOther(IResource resource, IProgressMonitor _progressMonitor, Map _buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IFullBuilder)) continue;
            ((IFullBuilder)builder).handleOther(resource, _progressMonitor, _buildCache);
        }
    }
}

