/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.classpath.model;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.objectstyle.woenvironment.frameworks.FrameworkModel;
import org.objectstyle.woenvironment.frameworks.Root;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.classpath.model.EclipseFolderRoot;
import org.objectstyle.wolips.jdt.classpath.model.EclipseProjectRoot;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;
import org.objectstyle.wolips.jdt.classpath.model.ProjectClasspathRoot;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.variables.ProjectVariables;
import org.objectstyle.wolips.variables.VariablesPlugin;

public class EclipseFrameworkModel
extends FrameworkModel<IEclipseFramework> {
    private static Map<File, Root<IEclipseFramework>> _folderRootCache = new HashMap<File, Root<IEclipseFramework>>();
    private static EclipseProjectRoot _projectRootCache;
    private IProject project;

    public EclipseFrameworkModel(IProject project) {
        this.project = project;
    }

    public static void invalidateProjectRootCache() {
        _projectRootCache = null;
    }

    public boolean shouldReload() {
        boolean shouldReload = false;
        for (Root root : this.getRoots()) {
            if (!root.shouldReload()) continue;
            shouldReload = true;
            break;
        }
        return shouldReload;
    }

    protected synchronized Root<IEclipseFramework> getCachedFolderRoot(String shortName, String name, File rootFolder, File frameworkFolder) {
        Object root = _folderRootCache.get(frameworkFolder);
        if (root == null || root.shouldReload()) {
            root = new EclipseFolderRoot(shortName, name, rootFolder, frameworkFolder);
            if (frameworkFolder != null) {
                _folderRootCache.put(frameworkFolder, (Root<IEclipseFramework>)root);
            }
        }
        return root;
    }

    protected synchronized List<Root<IEclipseFramework>> createRoots() {
        IFolder projectFrameworkFolder;
        String projectFrameworkFolderPath;
        BuildProperties buildProperties;
        ProjectAdapter projectAdapter;
        LinkedList<Root<IEclipseFramework>> roots = new LinkedList<Root<IEclipseFramework>>();
        if (_projectRootCache == null || _projectRootCache.shouldReload()) {
            _projectRootCache = new EclipseProjectRoot("Project", "Project Frameworks", ResourcesPlugin.getWorkspace().getRoot());
        }
        roots.add(_projectRootCache);
        ProjectAdapter projectAdapter2 = projectAdapter = this.project != null ? (ProjectAdapter)this.project.getAdapter(ProjectAdapter.class) : null;
        if (projectAdapter != null && (buildProperties = projectAdapter.getBuildProperties()) != null && (projectFrameworkFolderPath = buildProperties.getProjectFrameworkFolder()) != null && (projectFrameworkFolder = this.project.getFolder(projectFrameworkFolderPath)).exists()) {
            roots.add(this.getCachedFolderRoot("ProjectLocal", "Project Local Frameworks", projectFrameworkFolder.getLocation().toFile(), projectFrameworkFolder.getLocation().toFile()));
        }
        ProjectVariables variables = VariablesPlugin.getDefault().getProjectVariables(this.project);
        IPath externalBuildRootPath = variables.getExternalBuildRoot();
        IPath externalBuildFrameworkPath = variables.getExternalBuildFrameworkPath();
        if (externalBuildRootPath != null && externalBuildFrameworkPath != null) {
            roots.add(this.getCachedFolderRoot("External", "External Build Root", externalBuildFrameworkPath.toFile(), externalBuildRootPath.toFile()));
        }
        IPath userRoot = variables.getUserRoot();
        IPath userFrameworkPath = variables.getUserFrameworkPath();
        if (userRoot != null && userFrameworkPath != null) {
            roots.add(this.getCachedFolderRoot("User", "User Frameworks", userRoot.toFile(), userFrameworkPath.toFile()));
        }
        IPath localRoot = variables.getLocalRoot();
        IPath localFrameworkPath = variables.getLocalFrameworkPath();
        if (localRoot != null && localFrameworkPath != null) {
            roots.add(this.getCachedFolderRoot("Local", "Local Frameworks", localRoot.toFile(), localFrameworkPath.toFile()));
        }
        IPath systemRoot = variables.getSystemRoot();
        IPath systemFrameworkPath = variables.getSystemFrameworkPath();
        if (systemRoot != null && systemFrameworkPath != null) {
            roots.add(this.getCachedFolderRoot("System", "System Frameworks", systemRoot.toFile(), systemFrameworkPath.toFile()));
        }
        IPath networkRoot = variables.getNetworkRoot();
        IPath networkSystemPath = variables.getNetworkFrameworkPath();
        if (networkRoot != null && networkSystemPath != null) {
            roots.add(this.getCachedFolderRoot("Network", "Network Frameworks", networkRoot.toFile(), networkSystemPath.toFile()));
        }
        roots.add(new ProjectClasspathRoot("Classpath", "Project Classpath", this.project));
        return roots;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EclipseFrameworkModel) {
            EclipseFrameworkModel model = (EclipseFrameworkModel)((Object)obj);
            return model.project == this.project || model.project != null && model.project.equals(this.project);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return EclipseFrameworkModel.class.hashCode() + this.project.hashCode();
    }
}

