/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.preferences;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.objectstyle.wolips.preferences.ILaunchInfo;
import org.objectstyle.wolips.preferences.PreferencesMessages;
import org.objectstyle.wolips.preferences.PreferencesPlugin;

public class Preferences {
    public static final String PREF_WRITE_PB_DOT_PROJECT_ON_BUILD = "org.objectstyle.wolips.preference.WritePB_DotProjectOnBuild";
    public static final String PREF_MOCK_BUNDLE_ENABLED = "org.objectstyle.wolips.preference.MockBundleEnabled";
    public static final String PREF_WRITE_XCODE_ON_BUILD = "org.objectstyle.wolips.preference.WriteXcodeOnBuild";
    public static final String PREF_WRITE_XCODE21_ON_BUILD = "org.objectstyle.wolips.preference.WriteXcode21OnBuild";
    public static final String PREF_AUTOEOGENERATE_ON_BUILD = "org.objectstyle.wolips.preference.AutoEOGenerateOnBuild";
    public static final String PREF_CAPTURE_ANT_OUTPUT = "org.objectstyle.wolips.preference.CapureAntOutput";
    public static final String PREF_OPEN_WOCOMPONENT_ACTION_INCLUDES_OPEN_HTML = "org.objectstyle.wolips.Preference.OpenWOComponentActionIncludesOpenHTML";
    public static final String PREF_NS_PROJECT_SEARCH_PATH = "org.objectstyle.wolips.Preference.NSProjectSearch";
    public static final String PREF_REBUILD_WOBUILD_PROPERTIES_ON_NEXT_LAUNCH = "org.objectstyle.wolips.Preference.RebuildWOBuildPropertiesOnNextLaunch";
    public static final String PREF_WOLIPS_VERSION_EARLY_STARTUP = "org.objectstyle.wolips.Preference.WOLipsVersionEarlyStartup";
    public static final String PREF_LAUNCH_GLOBAL = "org.objectstyle.wolips.Preference.Launch_Global";
    public static final String PREF_EOGENERATOR_JAVA_14 = "org.objectstyle.wolips.Preference.EOGeneratorJava14";
    public static final String PREF_EOGENERATOR_PATH = "org.objectstyle.wolips.Preference.EOGeneratorPath";
    public static final String PREF_EOGENERATOR_TEMPLATE_DIR = "org.objectstyle.wolips.Preference.EOGeneratorTemplateDir";
    public static final String PREF_EOGENERATOR_JAVA_TEMPLATE = "org.objectstyle.wolips.Preference.EOGeneratorTemplate";
    public static final String PREF_EOGENERATOR_SUBCLASS_JAVA_TEMPLATE = "org.objectstyle.wolips.Preference.EOGeneratorSubclassTemplate";
    public static final String PREF_SHOW_CONSOLE_EXCEPTION_DIALOGS = "org.objectstyle.wolips.Preference.ConsoleExceptionDialogs";
    public static final String PREF_WOLIPS_PROPERTIES_FILE = "org.objectstyle.wolips.wolipsPropertiesFile";
    public static boolean FLAG_INCLUDE_EXCLUDE_RULES_CHANGED = false;
    public static final String trueString = "true";
    public static final String falseString = "false";
    private static String SET_DEFAULTS_STRING = null;

    public static void save() {
        IPersistentPreferenceStore pstore;
        IPreferenceStore store = Preferences.getPreferenceStore();
        if (store instanceof IPersistentPreferenceStore && (pstore = (IPersistentPreferenceStore)store).needsSaving()) {
            try {
                pstore.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void setDefaults() {
        IPreferenceStore store = Preferences.getPreferenceStore();
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_WOLIPS_PROPERTIES_FILE)) {
            store.setDefault(PREF_WOLIPS_PROPERTIES_FILE, "wolips.properties");
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_CAPTURE_ANT_OUTPUT)) {
            store.setDefault(PREF_CAPTURE_ANT_OUTPUT, falseString);
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_MOCK_BUNDLE_ENABLED)) {
            store.setDefault(PREF_MOCK_BUNDLE_ENABLED, trueString);
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_WRITE_PB_DOT_PROJECT_ON_BUILD)) {
            store.setDefault(PREF_WRITE_PB_DOT_PROJECT_ON_BUILD, falseString);
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_EOGENERATOR_PATH)) {
            store.setDefault(PREF_EOGENERATOR_PATH, "");
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_EOGENERATOR_TEMPLATE_DIR)) {
            store.setDefault(PREF_EOGENERATOR_TEMPLATE_DIR, "");
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_EOGENERATOR_JAVA_TEMPLATE)) {
            store.setDefault(PREF_EOGENERATOR_JAVA_TEMPLATE, "");
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_EOGENERATOR_SUBCLASS_JAVA_TEMPLATE)) {
            store.setDefault(PREF_EOGENERATOR_SUBCLASS_JAVA_TEMPLATE, "");
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_EOGENERATOR_JAVA_14)) {
            store.setDefault(PREF_EOGENERATOR_JAVA_14, falseString);
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_WRITE_XCODE_ON_BUILD)) {
            store.setDefault(PREF_WRITE_XCODE_ON_BUILD, falseString);
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_WRITE_XCODE21_ON_BUILD)) {
            store.setDefault(PREF_WRITE_XCODE21_ON_BUILD, falseString);
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_AUTOEOGENERATE_ON_BUILD)) {
            store.setDefault(PREF_AUTOEOGENERATE_ON_BUILD, falseString);
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_OPEN_WOCOMPONENT_ACTION_INCLUDES_OPEN_HTML)) {
            store.setDefault(PREF_OPEN_WOCOMPONENT_ACTION_INCLUDES_OPEN_HTML, falseString);
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_NS_PROJECT_SEARCH_PATH)) {
            store.setDefault(PREF_NS_PROJECT_SEARCH_PATH, "");
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_REBUILD_WOBUILD_PROPERTIES_ON_NEXT_LAUNCH)) {
            store.setDefault(PREF_REBUILD_WOBUILD_PROPERTIES_ON_NEXT_LAUNCH, PreferencesMessages.getString(falseString));
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_WOLIPS_VERSION_EARLY_STARTUP)) {
            store.setDefault(PREF_WOLIPS_VERSION_EARLY_STARTUP, "0.0.0");
        }
        if (SET_DEFAULTS_STRING == null || SET_DEFAULTS_STRING.equals(PREF_SHOW_CONSOLE_EXCEPTION_DIALOGS)) {
            store.setDefault(PREF_SHOW_CONSOLE_EXCEPTION_DIALOGS, PreferencesMessages.getString(trueString));
        }
        store.setDefault(PREF_LAUNCH_GLOBAL, PreferencesMessages.getString(PREF_LAUNCH_GLOBAL));
        SET_DEFAULTS_STRING = null;
    }

    public static synchronized String getString(String key) {
        IPreferenceStore store = Preferences.getPreferenceStore();
        String returnValue = store.getString(key);
        if (returnValue.equals("")) {
            Preferences.setDefaults();
            SET_DEFAULTS_STRING = key;
            returnValue = store.getString(key);
        }
        return returnValue;
    }

    public static void setString(String key, String value) {
        IPreferenceStore store = Preferences.getPreferenceStore();
        store.setValue(key, value);
    }

    private static boolean getBoolean(String key) {
        IPreferenceStore store = Preferences.getPreferenceStore();
        return trueString.equals(store.getString(key));
    }

    private static void setBoolean(String key, boolean value) {
        IPreferenceStore store = Preferences.getPreferenceStore();
        if (value) {
            store.setValue(key, trueString);
        } else {
            store.setValue(key, falseString);
        }
    }

    public static IPreferenceStore getPreferenceStore() {
        return PreferencesPlugin.getDefault().getPreferenceStore();
    }

    public static ILaunchInfo[] getLaunchInfoForKey(String key) {
        String string = Preferences.getString(key);
        return Preferences.getLaunchInfoFrom(string);
    }

    public static ILaunchInfo[] getLaunchInfoFrom(String string) {
        if (string == null) {
            return new ILaunchInfo[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreElements()) {
            String token = stringTokenizer.nextToken();
            vector.add(token);
        }
        ILaunchInfo[] launchInfo = new ILaunchInfo[vector.size() / 3];
        int j = 0;
        for (int i = 0; i < launchInfo.length; ++i) {
            launchInfo[i] = new LaunchInfo((String)vector.elementAt(j), (String)vector.elementAt(j + 1), (String)vector.elementAt(j + 2));
            j += 3;
        }
        return launchInfo;
    }

    public static String LaunchInfoToString(String[] parameter, String[] arguments, boolean[] enabled) {
        Object value = "";
        for (int i = 0; i < parameter.length; ++i) {
            value = (String)value + parameter[i];
            value = (String)value + "<>";
            value = (String)value + arguments[i];
            value = (String)value + "<>";
            value = (String)value + enabled[i];
            if (i == parameter.length - 1) continue;
            value = (String)value + "<>";
        }
        return value;
    }

    public static void setLaunchInfoForKey(String[] parameter, String[] arguments, boolean[] enabled, String key) {
        String value = Preferences.LaunchInfoToString(parameter, arguments, enabled);
        Preferences.setString(key, value);
    }

    public static String getLaunchGlobal() {
        return Preferences.getString(PREF_LAUNCH_GLOBAL);
    }

    public static String getNSProjectSearchPath() {
        return Preferences.getString(PREF_NS_PROJECT_SEARCH_PATH);
    }

    public static boolean getOpenWOComponentActionIncludesOpenHTML() {
        return Preferences.getBoolean(PREF_OPEN_WOCOMPONENT_ACTION_INCLUDES_OPEN_HTML);
    }

    public static boolean shouldRebuildWOBuildPropertiesOnNextLaunch() {
        return Preferences.getBoolean(PREF_REBUILD_WOBUILD_PROPERTIES_ON_NEXT_LAUNCH);
    }

    public static boolean shouldCaptureAntOutput() {
        return Preferences.getBoolean(PREF_CAPTURE_ANT_OUTPUT);
    }

    public static boolean mockBundleEnabled() {
        return Preferences.getBoolean(PREF_MOCK_BUNDLE_ENABLED);
    }

    public static boolean shouldWritePBProjOnBuild() {
        return Preferences.getBoolean(PREF_WRITE_PB_DOT_PROJECT_ON_BUILD);
    }

    public static boolean shouldWriteXcodeOnBuild() {
        return Preferences.getBoolean(PREF_WRITE_XCODE_ON_BUILD);
    }

    public static boolean shouldWriteXcodeProjOnBuild() {
        return Preferences.getBoolean(PREF_WRITE_XCODE21_ON_BUILD);
    }

    public static boolean shouldAutoEOGeneratorOnBuild() {
        return Preferences.getBoolean(PREF_AUTOEOGENERATE_ON_BUILD);
    }

    public static boolean isEOGeneratorJava14() {
        return Preferences.getBoolean(PREF_EOGENERATOR_JAVA_14);
    }

    public static void setEOGeneratorJava14(boolean eogeneratorJava14) {
        Preferences.setBoolean(PREF_EOGENERATOR_JAVA_14, eogeneratorJava14);
    }

    public static String getEOGeneratorPath() {
        return Preferences.getString(PREF_EOGENERATOR_PATH);
    }

    public static void setEOGeneratorPath(String _path) {
        Preferences.setString(PREF_EOGENERATOR_PATH, _path);
    }

    public static String getEOGeneratorTemplateDir() {
        return Preferences.getString(PREF_EOGENERATOR_TEMPLATE_DIR);
    }

    public static void setEOGeneratorTemplateDir(String _path) {
        Preferences.setString(PREF_EOGENERATOR_TEMPLATE_DIR, _path);
    }

    public static String getEOGeneratorJavaTemplate() {
        return Preferences.getString(PREF_EOGENERATOR_JAVA_TEMPLATE);
    }

    public static void setEOGeneratorJavaTemplate(String _path) {
        Preferences.setString(PREF_EOGENERATOR_JAVA_TEMPLATE, _path);
    }

    public static String getEOGeneratorSubclassJavaTemplate() {
        return Preferences.getString(PREF_EOGENERATOR_SUBCLASS_JAVA_TEMPLATE);
    }

    public static void setEOGeneratorSubclassJavaTemplate(String _path) {
        Preferences.setString(PREF_EOGENERATOR_SUBCLASS_JAVA_TEMPLATE, _path);
    }

    public static String getWOLipsVersionEarlyStartup() {
        return Preferences.getString(PREF_WOLIPS_VERSION_EARLY_STARTUP);
    }

    public static void setLaunchGlobal(String string) {
        Preferences.setString(PREF_LAUNCH_GLOBAL, string);
    }

    public static void setNSProjectSearchPath(String string) {
        Preferences.setString(PREF_NS_PROJECT_SEARCH_PATH, string);
    }

    public static void setOpenWOComponentActionIncludesOpenHTML(boolean value) {
        Preferences.setBoolean(PREF_OPEN_WOCOMPONENT_ACTION_INCLUDES_OPEN_HTML, value);
    }

    public static void setRebuildWOBuildPropertiesOnNextLaunch(boolean value) {
        Preferences.setBoolean(PREF_REBUILD_WOBUILD_PROPERTIES_ON_NEXT_LAUNCH, value);
    }

    public static void setCaptureAntOutput(boolean value) {
        Preferences.setBoolean(PREF_CAPTURE_ANT_OUTPUT, value);
    }

    public static void setWritePBProjOnBuild(boolean value) {
        Preferences.setBoolean(PREF_WRITE_PB_DOT_PROJECT_ON_BUILD, value);
    }

    public static void setWriteXcodeOnBuild(boolean value) {
        Preferences.setBoolean(PREF_WRITE_XCODE_ON_BUILD, value);
    }

    public static void setWriteXcodeProjOnBuild(boolean value) {
        Preferences.setBoolean(PREF_WRITE_XCODE21_ON_BUILD, value);
    }

    public static void setAutoEOGenerateOnBuild(boolean value) {
        Preferences.setBoolean(PREF_AUTOEOGENERATE_ON_BUILD, value);
    }

    public static void setWOLipsVersionEarlyStartup(String string) {
        Preferences.setString(PREF_WOLIPS_VERSION_EARLY_STARTUP, string);
    }

    public static void setShowConsoleExceptionDialogs(boolean value) {
        Preferences.setBoolean(PREF_SHOW_CONSOLE_EXCEPTION_DIALOGS, value);
    }

    public static boolean isShowConsoleExceptionDialogs() {
        return Preferences.getBoolean(PREF_SHOW_CONSOLE_EXCEPTION_DIALOGS);
    }

    private static class LaunchInfo
    implements ILaunchInfo {
        public String parameter;
        public String argument;
        public boolean enabled;

        public LaunchInfo(String parameter, String argument, String enabled) {
            this.parameter = parameter;
            this.argument = argument;
            this.enabled = enabled != null && Preferences.trueString.equals(enabled);
        }

        @Override
        public String getArgument() {
            return this.argument;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public String getParameter() {
            return this.parameter;
        }

        @Override
        public int compareTo(ILaunchInfo obj) {
            return this.parameter.compareTo(obj.getParameter());
        }
    }
}

