/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.kvc;

import java.util.Comparator;
import org.objectstyle.wolips.eomodeler.core.kvc.KeyPath;
import org.objectstyle.wolips.eomodeler.core.kvc.ResolvedKeyPath;

public class KVCComparator<T>
implements Comparator<T> {
    private KeyPath _keyPath;

    public KVCComparator(Class<T> clazz, String keyPath) {
        this._keyPath = new ResolvedKeyPath(clazz, keyPath);
    }

    public KVCComparator(String keyPath) {
        this._keyPath = new KeyPath(keyPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compare(Object o1, Object o2) {
        try {
            Object value1 = this._keyPath.getValue(o1);
            Object value2 = this._keyPath.getValue(o2);
            if (value1 == null) {
                if (value2 == null) {
                    return 0;
                }
                if (!(value2 instanceof Comparable)) throw new IllegalArgumentException(this._keyPath + " did not return a comparable value from " + o2);
                return 1;
            }
            if (value2 == null) {
                return -1;
            }
            if (!(value1 instanceof Comparable)) throw new IllegalArgumentException(this._keyPath + " did not return a comparable value from " + o1);
            return ((Comparable)value1).compareTo(value2);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to retrieve value of " + this._keyPath + " on " + o1 + " or " + o2 + ".", t);
        }
    }
}

