/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.Set;
import org.objectstyle.wolips.eomodeler.core.model.EODataSource;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;

public class EODatabaseDataSource
extends EODataSource {
    private static final String DEFAULT_EDITING_CONTEXT = "session.defaultEditingContext";
    private String _editingContext = "session.defaultEditingContext";
    private EOFetchSpecification _fetchSpecification;

    public EODatabaseDataSource(EOModelGroup modelGroup) {
        super(modelGroup);
    }

    @Override
    public void loadFromMap(EOModelMap map, Set<EOModelVerificationFailure> failures) {
        EOModelMap fspecMap = new EOModelMap(map.getMap("fetchSpecification"));
        String fspecName = map.getString("fetchSpecificationName", true);
        String entityName = fspecMap.getString("entityName", true);
        if (this.getModelGroup().getEntityNamed(entityName) != null) {
            if (fspecName == null) {
                this._fetchSpecification = new EOFetchSpecification(null);
                this._fetchSpecification.loadFromMap(fspecMap, failures);
                this._fetchSpecification.setEntity(this.getModelGroup().getEntityNamed(entityName));
            } else {
                this._fetchSpecification = this.getModelGroup().getEntityNamed(entityName).getFetchSpecNamed(fspecName);
            }
        }
        this._editingContext = map.getString("editingContext", true);
        if (this._editingContext == null) {
            this._editingContext = DEFAULT_EDITING_CONTEXT;
        }
    }

    public String getEditingContext() {
        return this._editingContext;
    }

    public void setEditingContext(String editingContext) {
        this._editingContext = editingContext;
    }

    public EOFetchSpecification getFetchSpecification() {
        if (this._fetchSpecification == null) {
            this._fetchSpecification = new EOFetchSpecification(null);
        }
        return this._fetchSpecification;
    }

    public void setFetchSpecification(EOFetchSpecification fetchSpecification) {
        this._fetchSpecification = fetchSpecification;
    }

    public String getEntityName() {
        if (this._fetchSpecification == null || this._fetchSpecification.getEntity() == null) {
            return null;
        }
        return this._fetchSpecification.getEntity().getName();
    }

    @Override
    public EOModelMap toMap() {
        EOModelMap modelMap = new EOModelMap();
        modelMap.setString("class", "EODatabaseDataSource", true);
        modelMap.setString("editingContext", this._editingContext, true);
        if (this._fetchSpecification != null) {
            modelMap.setMap("fetchSpecification", this._fetchSpecification.toMap(), true);
            String fetchSpecName = this._fetchSpecification.getName();
            if (fetchSpecName != null) {
                modelMap.setString("fetchSpecificationName", fetchSpecName, true);
            }
        }
        return modelMap;
    }
}

