/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.Set;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;

public class EORelationshipPath
extends AbstractEOAttributePath {
    public EORelationshipPath(EORelationshipPath _parentRelationshipPath, EORelationship _childRelationship) {
        super(_parentRelationshipPath, _childRelationship);
    }

    public EORelationship getChildRelationship() {
        return (EORelationship)this.getChildIEOAttribute();
    }

    @Override
    public String getChildClassName() {
        EOEntity destination;
        String className = null;
        EORelationship relationship = this.getChildRelationship();
        if (relationship != null && (destination = relationship.getActualDestination()) != null) {
            className = destination.getClassNameWithDefault();
        }
        return className;
    }

    public AbstractEOAttributePath[] getChildren() {
        AbstractEOAttributePath[] children;
        EOEntity entity = this.getChildRelationship().getDestination();
        if (entity != null) {
            Set<EORelationship> relationshipsList = entity.getRelationships();
            Set<EOAttribute> attributesList = entity.getAttributes();
            children = new AbstractEOAttributePath[relationshipsList.size() + attributesList.size()];
            int childNum = 0;
            for (EORelationship childRelationship : relationshipsList) {
                children[childNum] = new EORelationshipPath(this, childRelationship);
                ++childNum;
            }
            for (EOAttribute childAttribute : attributesList) {
                children[childNum] = new EOAttributePath(this, childAttribute);
                ++childNum;
            }
        } else {
            children = new AbstractEOAttributePath[]{};
        }
        return children;
    }

    public String toString() {
        return "[EORelationshipPath: " + this.toKeyPath() + "]";
    }
}

