/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.viewers.TableViewer;
import org.objectstyle.wolips.eomodeler.utils.SelectionThrottle;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class TableRefreshPropertyListener
implements PropertyChangeListener {
    private SelectionThrottle _throttle;
    private TableViewer _tableViewer;

    public TableRefreshPropertyListener(String name, TableViewer tableViewer) {
        this._tableViewer = tableViewer;
        this._throttle = new SelectionThrottle(name, new SelectionThrottle.TableViewerSelectionHandler(tableViewer));
    }

    public void start() {
        this._throttle.start();
    }

    public void stop() {
        this._throttle.stop();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (oldValue instanceof Collection && newValue instanceof Collection) {
            HashSet newSet = new HashSet((Collection)newValue);
            newSet.removeAll((Collection)oldValue);
            this._tableViewer.add(newSet.toArray());
            HashSet oldSet = new HashSet((Collection)oldValue);
            oldSet.removeAll((Collection)newValue);
            this._tableViewer.remove(oldSet.toArray());
            this._throttle.objectsAdded(newSet);
            this._throttle.objectsRemoved(oldSet);
            TableUtils.packTableColumns(this._tableViewer);
        } else {
            this._tableViewer.refresh(source, true);
        }
    }
}

