/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforuiplugins.plist;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforuiplugins.plist.IPropertyListChangeListener;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListPath;
import org.objectstyle.wolips.baseforuiplugins.utils.WOTextCellEditor;

public class PropertyListValueEditingSupport
extends EditingSupport {
    private IPropertyListChangeListener _listener;
    private TreeViewer _treeViewer;
    private TextCellEditor _textCellEditor;

    public PropertyListValueEditingSupport(TreeViewer viewer, IPropertyListChangeListener listener) {
        super((ColumnViewer)viewer);
        this._listener = listener;
        this._treeViewer = viewer;
        this._textCellEditor = new WOTextCellEditor((Composite)this._treeViewer.getTree());
    }

    protected boolean canEdit(Object element) {
        return !((PropertyListPath)element).isCollectionValue();
    }

    protected CellEditor getCellEditor(Object element) {
        return this._textCellEditor;
    }

    protected Object getValue(Object element) {
        PropertyListPath path = (PropertyListPath)element;
        return path.convertValueToType(PropertyListPath.Type.String);
    }

    protected void setValue(Object element, Object value) {
        PropertyListPath path = (PropertyListPath)element;
        String strValue = (String)value;
        Object convertedValue = PropertyListPath.convertValueFromTypeToType(path.getKeyPath(), strValue, PropertyListPath.Type.String, path.getType(), path.getFactory());
        Object oldValue = path.getValue();
        if (!ComparisonUtils.equals((Object)oldValue, (Object)convertedValue)) {
            boolean parentChanged = path.setValue(convertedValue);
            if (parentChanged) {
                this._listener.pathChanged(path.getParent().getKeyPath(), oldValue, convertedValue);
                this._treeViewer.refresh((Object)path.getParent());
            } else {
                this._listener.pathChanged(path.getKeyPath(), oldValue, convertedValue);
                this._treeViewer.refresh((Object)path);
            }
        }
    }
}

