/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.core.tobeintregrated.MethodSearch;

public class FindUnusedWOCodeAction
implements IObjectActionDelegate {
    private ISelection selection;
    private Shell shell;

    public void run(IAction action) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.shell = workbench.getActiveWorkbenchWindow().getShell();
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null || !MessageDialog.openConfirm((Shell)this.shell, (String)"Confirm action", (String)("Processing project: " + project.getName() + "\n\nPlease save changes before and check that no compiler errors exist."))) continue;
                try {
                    MethodSearch methodSearcher;
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    MethodSearch op = methodSearcher = new MethodSearch(javaProject);
                    ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.shell);
                    progressDialog.run(true, true, (IRunnableWithProgress)op);
                    MessageDialog formatDialog = new MessageDialog(this.shell, "Output Format", null, "What kind of output do you want?", 0, new String[]{"cancel", "Comments", "Text File"}, 1);
                    formatDialog.open();
                    if (formatDialog.getReturnCode() == 2) {
                        InputDialog inputDialog = new InputDialog(this.shell, "Output text file", "Where do you want to save the file?", "file path including name", null);
                        inputDialog.open();
                        if (inputDialog.getReturnCode() != 0) continue;
                        String path = inputDialog.getValue();
                        while (path == null || path.length() == 0) {
                            inputDialog.open();
                            inputDialog.setErrorMessage("Wrong Input");
                            path = inputDialog.getValue();
                        }
                        methodSearcher.writePossiblyUnusedMethodsToFile(new File(path));
                        continue;
                    }
                    if (formatDialog.getReturnCode() != 1 || methodSearcher.setComments()) continue;
                    throw new InterruptedException();
                }
                catch (InvocationTargetException e) {
                    StackTraceElement[] stackTraces = e.getStackTrace();
                    Object stackTraceString = "";
                    for (int i = 0; i < stackTraces.length; ++i) {
                        stackTraceString = (String)stackTraceString + stackTraces[i].toString() + "\n";
                    }
                    MessageDialog.openError((Shell)this.shell, (String)"Error", (String)("Error searching for unused WO code:\n\n" + e.toString() + "\n\n" + e.getCause().toString()));
                }
                catch (InterruptedException e) {
                    MessageDialog.openWarning((Shell)this.shell, (String)"Process Canceled", (String)"Search for unsused WO code canceled");
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection newSelection) {
        this.selection = newSelection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

