/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.objectstyle.wolips.templateengine.TemplateDefinition;
import org.objectstyle.wolips.templateengine.TemplateEngine;
import org.objectstyle.wolips.wizards.WizardsPlugin;

public class WOSubprojectCreator
implements IRunnableWithProgress {
    private String subprojectName;
    private IResource parentResource;

    public WOSubprojectCreator(IResource parentResource, String subprojectName) {
        this.subprojectName = subprojectName + ".subproj";
        this.parentResource = parentResource;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            this.createSubproject(monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void createSubproject(IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        IFolder subprojectFolder = null;
        switch (this.parentResource.getType()) {
            case 4: {
                subprojectFolder = ((IProject)this.parentResource).getFolder(this.subprojectName);
                break;
            }
            case 2: {
                subprojectFolder = ((IFolder)this.parentResource).getFolder(this.subprojectName);
                break;
            }
            default: {
                throw new InvocationTargetException(new Exception("Wrong parent resource - check validation"));
            }
        }
        subprojectFolder.create(false, true, monitor);
        String path = subprojectFolder.getLocation().toOSString();
        TemplateEngine templateEngine = new TemplateEngine();
        try {
            templateEngine.init();
        }
        catch (Exception e) {
            WizardsPlugin.getDefault().log(e);
            throw new InvocationTargetException(e);
        }
        templateEngine.getWolipsContext().setProjectName(this.subprojectName);
        templateEngine.addTemplate(new TemplateDefinition("subproject/PB.project.vm", path, "PB.project", "PB.project"));
        try {
            templateEngine.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            WizardsPlugin.getDefault().log(e);
            throw new InvocationTargetException(e);
        }
        subprojectFolder.refreshLocal(2, monitor);
        IFolder sourceFolder = subprojectFolder.getFolder("src");
        if (!sourceFolder.exists()) {
            try {
                sourceFolder.create(true, true, monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.parentResource.getProject());
        IClasspathEntry classpathEntry = JavaCore.newSourceEntry((IPath)sourceFolder.getFullPath());
        IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
        IClasspathEntry[] newClasspathEntries = new IClasspathEntry[classpathEntries.length + 1];
        System.arraycopy(classpathEntries, 0, newClasspathEntries, 0, classpathEntries.length);
        newClasspathEntries[classpathEntries.length] = classpathEntry;
        javaProject.setRawClasspath(newClasspathEntries, monitor);
    }
}

