/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.baseforplugins.Activator;

public class WOLipsNatureUtils {
    public static final String INCREMENTAL_FRAMEWORK_ID = "org.objectstyle.wolips.incrementalframeworknature";
    public static final String INCREMENTAL_APPLICATION_ID = "org.objectstyle.wolips.incrementalapplicationnature";
    public static final String ANT_FRAMEWORK_ID = "org.objectstyle.wolips.antframeworknature";
    public static final String ANT_APPLICATION_ID = "org.objectstyle.wolips.antapplicationnature";
    private static final String TARGET_BUILDER_ID = "org.objectstyle.wolips.targetbuilder.targetbuildernature";
    private static final String[] NATURES = new String[]{"org.objectstyle.wolips.incrementalframeworknature", "org.objectstyle.wolips.incrementalapplicationnature", "org.objectstyle.wolips.antframeworknature", "org.objectstyle.wolips.antapplicationnature"};

    public static boolean addIncrementalFrameworkNatureToProject(IProject project, IProgressMonitor monitor) throws CoreException {
        return WOLipsNatureUtils.addNatureToProject(INCREMENTAL_FRAMEWORK_ID, project, monitor);
    }

    public static boolean addIncrementalApplicationNatureToProject(IProject project, IProgressMonitor monitor) throws CoreException {
        return WOLipsNatureUtils.addNatureToProject(INCREMENTAL_APPLICATION_ID, project, monitor);
    }

    public static boolean addAntFrameworkNatureToProject(IProject project, IProgressMonitor monitor) throws CoreException {
        return WOLipsNatureUtils.addNatureToProject(ANT_FRAMEWORK_ID, project, monitor);
    }

    public static boolean addAntApplicationNatureToProject(IProject project, IProgressMonitor monitor) throws CoreException {
        return WOLipsNatureUtils.addNatureToProject(ANT_APPLICATION_ID, project, monitor);
    }

    public static boolean addNatureToProject(String id, IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectNature nature = project.getNature(id);
        if (nature == null) {
            IProjectDescription description = project.getDescription();
            ArrayList<String> naturesList = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
            naturesList.add(id);
            description.setNatureIds(naturesList.toArray(new String[naturesList.size()]));
            project.setDescription(description, monitor);
        }
        return project.isNatureEnabled(id);
    }

    public static void removeNaturesFromProject(IProject project, IProgressMonitor monitor) throws CoreException {
        WOLipsNatureUtils.setNatureForProject(null, false, project, monitor);
    }

    public static void setNatureForProject(String id, boolean useTargetBuilder, IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        ArrayList<String> naturesList = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
        naturesList.remove(ANT_APPLICATION_ID);
        naturesList.remove(ANT_FRAMEWORK_ID);
        naturesList.remove(INCREMENTAL_APPLICATION_ID);
        naturesList.remove(INCREMENTAL_FRAMEWORK_ID);
        naturesList.remove(TARGET_BUILDER_ID);
        if (id != null) {
            naturesList.add(id);
        }
        if (useTargetBuilder) {
            naturesList.add(TARGET_BUILDER_ID);
        }
        description.setNatureIds(naturesList.toArray(new String[naturesList.size()]));
        project.setDescription(description, monitor);
    }

    public static void removeNatureFromProject(String id, IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectNature nature = project.getNature(id);
        if (nature != null) {
            IProjectDescription description = project.getDescription();
            ArrayList<String> naturesList = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
            naturesList.remove(id);
            description.setNatureIds(naturesList.toArray(new String[naturesList.size()]));
            project.setDescription(description, monitor);
        }
    }

    public static IProjectNature getNature(IProject project) {
        if (!project.isAccessible() || !project.exists()) {
            return null;
        }
        IProjectNature nature = null;
        try {
            for (int i = 0; i < NATURES.length; ++i) {
                nature = project.getNature(NATURES[i]);
                if (nature == null) continue;
                return nature;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().debug("Error while resolving nature for project: " + project.getName(), e);
        }
        return nature;
    }

    public static boolean isWOLipsNature(IProject project) {
        return WOLipsNatureUtils.getNature(project) != null;
    }

    public static boolean isMavenNature(IProject project) {
        try {
            IProjectNature nature = project.getNature("org.maven.ide.eclipse.maven2Nature");
            if (nature == null) {
                nature = project.getNature("org.eclipse.m2e.core.maven2Nature");
            }
            if (nature != null) {
                return true;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().debug("Error while resolving nature for project: " + project.getName(), e);
        }
        return false;
    }
}

