/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.errors;

import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.objectstyle.wolips.launching.LaunchingPlugin;
import org.objectstyle.wolips.launching.exceptionhandler.IExceptionHandler;
import org.objectstyle.wolips.launching.exceptionhandler.internal.ExceptionHandlerWrapper;
import org.objectstyle.wolips.preferences.Preferences;

public class ErrorConsoleLineTracker
implements IConsoleLineTracker {
    private IConsole currentConsole;
    private ExceptionHandlerWrapper[] exceptionHandlerWrappers;
    private int[] linesToSkip;
    private boolean enabled;

    public void init(IConsole console) {
        this.currentConsole = console;
        this.exceptionHandlerWrappers = LaunchingPlugin.getDefault().getExceptionHandlerWrapper();
        this.linesToSkip = new int[this.exceptionHandlerWrappers.length];
        this.enabled = Preferences.isShowConsoleExceptionDialogs();
    }

    public void lineAppended(IRegion line) {
        int offset = line.getOffset();
        int length = line.getLength();
        String text = null;
        try {
            text = this.currentConsole.getDocument().get(offset, length);
            this.incrementLinesToSkip();
            this.forwardLineAppended(text);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void incrementLinesToSkip() {
        for (int i = 0; i < this.linesToSkip.length; ++i) {
            int currentLinesToSkip = this.linesToSkip[i];
            if (currentLinesToSkip <= 0) continue;
            this.linesToSkip[i] = --currentLinesToSkip;
        }
    }

    private void forwardLineAppended(String line) {
        if (this.enabled) {
            for (int i = 0; i < this.exceptionHandlerWrappers.length; ++i) {
                ExceptionHandlerWrapper exceptionHandlerWrapper = this.exceptionHandlerWrappers[i];
                IExceptionHandler exceptionHandler = exceptionHandlerWrapper.getExceptionHandler();
                if (this.linesToSkip[i] > 0) continue;
                this.linesToSkip[i] = exceptionHandler.lineAppendedToConsole(line, this.currentConsole);
            }
        }
    }

    public void dispose() {
        this.currentConsole = null;
    }
}

