/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards.template;

import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.objectstyle.wolips.templateengine.ProjectTemplate;
import org.objectstyle.wolips.wizards.template.TemplateContentProvider;
import org.objectstyle.wolips.wizards.template.TemplateLabelProvider;

public class SelectTemplateWizardPage
extends WizardPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private List<ProjectTemplate> _templates;
    private ListViewer _templateViewer;
    private ProjectTemplate _selectedProjectTemplate;

    protected SelectTemplateWizardPage() {
        super("Select Template");
        this.setPageComplete(false);
        this._templates = ProjectTemplate.loadProjectTemplates((String)"Project Templates");
    }

    public List<ProjectTemplate> getProjectTemplates() {
        return this._templates;
    }

    public ProjectTemplate getSelectedProjectTemplate() {
        return this._selectedProjectTemplate;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)parent);
        if (this._templates.size() == 0) {
            this.setTitle("No Templates Found");
            Label noTemplatesLabel = new Label(composite, 0);
            noTemplatesLabel.setText("There are no templates available.");
        } else {
            this.setTitle("Select a Template");
            this._templateViewer = new ListViewer(composite, 2564);
            this._templateViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
            this._templateViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
            this._templateViewer.setInput(this._templates);
            this._templateViewer.getList().setLayoutData((Object)new GridData(1808));
            this._templateViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this._templateViewer.addDoubleClickListener((IDoubleClickListener)this);
        }
        this.setControl((Control)composite);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection templateSelection = (IStructuredSelection)event.getSelection();
        this._selectedProjectTemplate = (ProjectTemplate)templateSelection.getFirstElement();
        this.setPageComplete(this._selectedProjectTemplate != null);
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.isPageComplete()) {
            this.getWizard().getContainer().showPage(this.getNextPage());
        }
    }
}

