/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.deployment.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.objectstyle.wolips.deployment.ui.actions.AbstractInstallAction;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;

public class InstallWithSelectionDialogAction
extends AbstractInstallAction {
    IProject[] iProjects;

    private IProject[] getIProjects() {
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            ProjectFrameworkAdapter project;
            IProject iProject = projects[i];
            if (!iProject.isAccessible() || !iProject.isOpen() || !iProject.getFile("build.xml").exists() || (project = (ProjectFrameworkAdapter)this.getIProject().getAdapter(ProjectFrameworkAdapter.class)) == null) continue;
            if (iProject == this.getIProject()) {
                arrayList.add(iProject);
                continue;
            }
            if (!project.isFrameworkReference(iProject)) continue;
            arrayList.add(iProject);
        }
        return arrayList.toArray(new IProject[arrayList.size()]);
    }

    public void run(IAction action) {
        IStructuredContentProvider structuredContentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof String) {
                    IWorkspace.ProjectOrder projectOrder = ResourcesPlugin.getWorkspace().computeProjectOrder(ResourcesPlugin.getWorkspace().getRoot().getProjects());
                    return projectOrder.projects;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        ILabelProvider labelProvider = new ILabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof IProject) {
                    return ((IProject)element).getName();
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        this.iProjects = this.getIProjects();
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(new Shell(), (Object)"WOLips", structuredContentProvider, labelProvider, "Select the projects to install.");
        listSelectionDialog.setInitialSelections((Object[])this.iProjects);
        listSelectionDialog.open();
        if (listSelectionDialog.getReturnCode() == 1) {
            return;
        }
        Object[] selectionResult = listSelectionDialog.getResult();
        IProject[] projectsSelected = new IProject[selectionResult.length];
        for (int i = 0; i < selectionResult.length; ++i) {
            projectsSelected[i] = (IProject)selectionResult[i];
        }
        IWorkspace.ProjectOrder projectOrder = ResourcesPlugin.getWorkspace().computeProjectOrder(projectsSelected);
        this.install(projectOrder.projects);
    }
}

