/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.componenteditor.actions.ComponentInstanceNameVerifyListener;
import org.objectstyle.wolips.componenteditor.actions.InsertComponentSpecification;
import org.objectstyle.wolips.wodclipse.action.ComponentLiveSearch;

public class InsertComponentDialogue
extends Dialog {
    protected Label _componentNameLabel;
    protected Combo _componentNameCombo;
    protected Label _componentInstanceLabel;
    protected Text _componentInstanceNameText;
    protected Button _componentInstanceCreateButton;
    protected Button _componentInstanceCancelButton;
    protected Button _inline;
    protected IJavaProject _project;
    protected InsertComponentSpecification _insertComponentSpecification;
    protected IProgressMonitor _progressMonitor;

    public InsertComponentDialogue(Shell parentShell, IJavaProject project, InsertComponentSpecification insertComponentSpecification) {
        super(parentShell);
        this._project = project;
        this._insertComponentSpecification = insertComponentSpecification;
        this._progressMonitor = new NullProgressMonitor();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String componentName = this._insertComponentSpecification.getComponentName();
        if (componentName == null) {
            newShell.setText("Insert Component");
        } else {
            newShell.setText("Insert " + componentName);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        this._inline = new Button(composite, 32);
        this._inline.setText("Use inline bindings");
        GridData inlineData = new GridData(768);
        inlineData.horizontalSpan = 2;
        this._inline.setLayoutData((Object)inlineData);
        this._inline.setSelection(Activator.getDefault().useInlineBindings(this._project.getProject()));
        this._componentInstanceLabel = new Label(composite, 0);
        this._componentInstanceLabel.setText("WebObject tag name:");
        GridData componentInstanceLabelLayout = new GridData(768);
        this._componentInstanceLabel.setLayoutData((Object)componentInstanceLabelLayout);
        this._componentInstanceNameText = new Text(composite, 2048);
        GridData componentInstanceNameLayout = new GridData(768);
        componentInstanceNameLayout.widthHint = 200;
        this._componentInstanceNameText.setLayoutData((Object)componentInstanceNameLayout);
        this._componentInstanceNameText.addVerifyListener((VerifyListener)new ComponentInstanceNameVerifyListener());
        this._componentInstanceNameText.setFocus();
        if (this._insertComponentSpecification.getComponentInstanceName() != null) {
            this._componentInstanceNameText.setText(this._insertComponentSpecification.getComponentInstanceName());
        }
        if (this._insertComponentSpecification.getComponentName() == null) {
            this._componentNameLabel = new Label(composite, 0);
            this._componentNameLabel.setText("Component type:");
            GridData componentNameLabelLayout = new GridData(768);
            this._componentNameLabel.setLayoutData((Object)componentNameLabelLayout);
            this._componentNameCombo = new Combo(composite, 2048);
            GridData componentNameTextLayout = new GridData(768);
            this._componentNameCombo.setLayoutData((Object)componentNameTextLayout);
            new ComponentLiveSearch(this._project, this._progressMonitor).attachTo(this._componentNameCombo);
        }
        this._inline.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InsertComponentDialogue.this.inlineSelectionChanged();
                InsertComponentDialogue.this.validate();
            }
        });
        this._componentInstanceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InsertComponentDialogue.this.validate();
            }
        });
        if (this._componentNameCombo != null) {
            this._componentNameCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InsertComponentDialogue.this.validate();
                }
            });
        }
        this.inlineSelectionChanged();
        return this.dialogArea;
    }

    protected void inlineSelectionChanged() {
        this._componentInstanceNameText.setEnabled(!this._inline.getSelection());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    public void cancelPressed() {
        this._insertComponentSpecification = null;
        super.cancelPressed();
    }

    public void okPressed() {
        if (this._componentNameCombo != null) {
            this._insertComponentSpecification.setComponentName(this._componentNameCombo.getText());
        }
        this._insertComponentSpecification.setComponentInstanceName(this._componentInstanceNameText.getText());
        this._insertComponentSpecification.setInline(this._inline.getSelection());
        Activator.getDefault().setUseInlineBindings(this._project.getProject(), this._inline.getSelection());
        super.okPressed();
    }

    public InsertComponentSpecification getInsertComponentSpecification() {
        return this._insertComponentSpecification;
    }

    protected void validate() {
        Button okButton;
        boolean isValid = false;
        if (this._componentNameCombo == null || !"".equals(this._componentNameCombo.getText())) {
            if (this._inline.getSelection()) {
                isValid = true;
            } else if (!"".equals(this._componentInstanceNameText.getText())) {
                isValid = true;
            }
        }
        if ((okButton = this.getButton(0)) == null) {
            return;
        }
        if (isValid) {
            if (!okButton.isEnabled()) {
                okButton.setEnabled(true);
            }
        } else if (okButton.isEnabled()) {
            okButton.setEnabled(false);
        }
    }
}

