/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.objectstyle.wolips.componenteditor.inspector.BindingsInspectorPage;
import org.objectstyle.wolips.componenteditor.part.ComponentEditor;
import org.objectstyle.wolips.templateeditor.TemplateEditor;
import org.objectstyle.wolips.wodclipse.core.util.ICursorPositionListener;
import org.objectstyle.wolips.wodclipse.editor.WodEditor;

public class BindingsInspectorPageBookView
extends PageBookView
implements ICursorPositionListener {
    private TextEditor _lastEditor;
    private Point _lastSelectionRange;

    protected IPage createDefaultPage(PageBook book) {
        BindingsInspectorPage page = new BindingsInspectorPage(null);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        return page;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    public void dispose() {
        super.dispose();
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        PageBookView.PageRec pageRec = null;
        if (part instanceof ComponentEditor) {
            ComponentEditor componentEditor = (ComponentEditor)part;
            BindingsInspectorPage page = new BindingsInspectorPage(componentEditor);
            this.initPage((IPageBookViewPage)page);
            page.createControl((Composite)this.getPageBook());
            pageRec = new PageBookView.PageRec(part, (IPage)page);
        }
        return pageRec;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec rec) {
        BindingsInspectorPage page = (BindingsInspectorPage)rec.page;
        page.dispose();
        rec.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActivePart();
        }
        return null;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof ComponentEditor;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        super.partBroughtToTop(part);
    }

    public void partDeactivated(IWorkbenchPart part) {
        super.partDeactivated(part);
        if (part instanceof ComponentEditor) {
            WodEditor wodEditor;
            ComponentEditor componentEditor = (ComponentEditor)part;
            TemplateEditor templateEditor = componentEditor.getTemplateEditor();
            if (templateEditor != null) {
                templateEditor.getSourceEditor().removeCursorPositionListener((ICursorPositionListener)this);
            }
            if ((wodEditor = componentEditor.getWodEditor()) != null) {
                wodEditor.removeCursorPositionListener((ICursorPositionListener)this);
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part instanceof ComponentEditor) {
            WodEditor wodEditor;
            ComponentEditor componentEditor = (ComponentEditor)part;
            TemplateEditor templateEditor = componentEditor.getTemplateEditor();
            if (templateEditor != null) {
                templateEditor.getSourceEditor().addCursorPositionListener((ICursorPositionListener)this);
            }
            if ((wodEditor = componentEditor.getWodEditor()) != null) {
                wodEditor.addCursorPositionListener((ICursorPositionListener)this);
            }
        } else if (part instanceof BindingsInspectorPageBookView && this._lastEditor != null && this._lastSelectionRange != null) {
            this.cursorPositionChanged(this._lastEditor, this._lastSelectionRange);
        }
    }

    public void cursorPositionChanged(TextEditor editor, Point selectionRange) {
        BindingsInspectorPage page;
        if (this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this) && (page = (BindingsInspectorPage)this.getCurrentPage()) != null) {
            page.cursorPositionChanged(editor, selectionRange);
        }
        this._lastEditor = editor;
        this._lastSelectionRange = selectionRange;
    }

    protected Object getViewAdapter(Class key) {
        if (ISaveablePart.class.equals((Object)key)) {
            return this.getSaveablePart();
        }
        return super.getViewAdapter(key);
    }

    protected ISaveablePart getSaveablePart() {
        IWorkbenchPart part = this.getCurrentContributingPart();
        if (part instanceof ISaveablePart) {
            return (ISaveablePart)part;
        }
        return null;
    }
}

