/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.objectstyle.wolips.componenteditor.outline.EmptyOutlinePage;

public class ComponentEditorOutline
extends Page
implements IContentOutlinePage,
ISelectionProvider,
ISelectionChangedListener {
    private PageBook pagebook;
    private IContentOutlinePage currentPage;
    private IContentOutlinePage emptyPage;
    private IActionBars actionBars;
    private IMenuManager menuManager;
    private IToolBarManager toolBarManager;
    private IStatusLineManager statusLineManager;
    private ISelection selection;
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

    public void createControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
    }

    public void dispose() {
        if (this.pagebook != null && !this.pagebook.isDisposed()) {
            this.pagebook.dispose();
        }
        this.pagebook = null;
        this.listeners = null;
    }

    public boolean isDisposed() {
        return this.listeners == null;
    }

    public Control getControl() {
        return this.pagebook;
    }

    public PageBook getPagebook() {
        return this.pagebook;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.listeners == null) {
            return;
        }
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).selectionChanged(e);
        }
    }

    public void makeContributions(IMenuManager newMenuManager, IToolBarManager newToolBarManager, IStatusLineManager newStatusLineManager) {
        this.menuManager = newMenuManager;
        this.toolBarManager = newToolBarManager;
        this.statusLineManager = newStatusLineManager;
    }

    public void setActionBars(IActionBars actionBars) {
        this.actionBars = actionBars;
        if (this.currentPage != null) {
            this.setPageActive(this.currentPage);
        }
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    public void setFocus() {
        if (this.currentPage != null) {
            this.currentPage.setFocus();
        }
    }

    private IContentOutlinePage getEmptyPage() {
        if (this.emptyPage == null) {
            this.emptyPage = new EmptyOutlinePage();
        }
        return this.emptyPage;
    }

    public void setPageActive(IContentOutlinePage contentOutlinePage) {
        IContentOutlinePage page = contentOutlinePage;
        if (page == null) {
            page = this.getEmptyPage();
        }
        if (this.currentPage != null) {
            this.currentPage.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        page.addSelectionChangedListener((ISelectionChangedListener)this);
        this.currentPage = page;
        if (this.pagebook == null) {
            return;
        }
        Control control = page.getControl();
        if (control == null || control.isDisposed()) {
            if (page instanceof Page) {
                ((Page)page).init(this.getSite());
            }
            page.setActionBars(this.getActionBars());
            page.createControl((Composite)this.pagebook);
            control = page.getControl();
            if (page instanceof Page) {
                ((Page)page).makeContributions(this.menuManager, this.toolBarManager, this.statusLineManager);
            }
        }
        this.pagebook.showPage(control);
        this.currentPage = page;
    }
}

