/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforuiplugins.plist;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforuiplugins.plist.IPropertyListChangeListener;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListPath;
import org.objectstyle.wolips.baseforuiplugins.utils.WOTextCellEditor;

public class PropertyListKeyEditingSupport
extends EditingSupport {
    private IPropertyListChangeListener _listener;
    private TreeViewer _treeViewer;
    private TextCellEditor _textCellEditor;

    public PropertyListKeyEditingSupport(TreeViewer viewer, IPropertyListChangeListener listener) {
        super((ColumnViewer)viewer);
        this._listener = listener;
        this._treeViewer = viewer;
        this._textCellEditor = new WOTextCellEditor((Composite)this._treeViewer.getTree());
    }

    protected boolean canEdit(Object element) {
        return ((PropertyListPath)element).isRealKey();
    }

    protected CellEditor getCellEditor(Object element) {
        return this._textCellEditor;
    }

    protected Object getValue(Object element) {
        return ((PropertyListPath)element).getKey();
    }

    protected void setValue(Object element, Object key) {
        PropertyListPath path = (PropertyListPath)element;
        String oldKeyPath = path.getKeyPath();
        String oldKey = path.getKey();
        if (!ComparisonUtils.equals((Object)oldKey, (Object)key) && path.setKey(key)) {
            this._listener.pathRenamed(oldKeyPath, path.getParent().getKeyPath());
            PropertyListPath newPath = path.getParent().getChildForKey(key);
            if (newPath != null) {
                this._treeViewer.refresh((Object)newPath.getParent());
            }
        }
    }
}

