/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.completion;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.wod.HtmlElementCache;
import org.objectstyle.wolips.bindings.wod.HtmlElementName;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodElementProblem;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.bindings.wod.WodElementProblem;
import org.objectstyle.wolips.bindings.wod.WodProblem;
import org.objectstyle.wolips.wodclipse.core.completion.AbstractCacheEntry;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.WodFileDocumentProvider;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;
import org.objectstyle.wolips.wodclipse.core.util.WodModelUtils;

public class WodCacheEntry
extends AbstractCacheEntry<IWodModel> {
    public WodCacheEntry(WodParserCache cache) {
        super(cache);
    }

    @Override
    public void validate() throws Exception {
        this.setValidated(true);
        IWodModel wodModel = (IWodModel)this._getModel();
        if (wodModel != null) {
            WodParserCache cache = this.getCache();
            IJavaProject javaProject = cache.getJavaProject();
            IType componentType = cache.getComponentType();
            HtmlElementCache htmlElementCache = cache.getHtmlEntry().getHtmlElementCache();
            List wodProblems = wodModel.getProblems(javaProject, componentType, WodParserCache.getTypeCache(), htmlElementCache);
            IFile wodFile = this.getFile();
            if (wodFile != null && wodFile.exists()) {
                IFile htmlFile = cache.getHtmlEntry().getFile();
                boolean createHtmlMarkers = htmlFile != null && htmlFile.exists();
                for (WodProblem wodProblem : wodProblems) {
                    List htmlElementNames;
                    IWodElement element;
                    WodModelUtils.createMarker(wodFile, wodProblem);
                    String wodErrorsInHtmlSeverity = Activator.getDefault().getPluginPreferences().getString("WodErrorsInHtmlSeverityKey");
                    if ("ignore".equals(wodErrorsInHtmlSeverity) || !createHtmlMarkers || !(wodProblem instanceof IWodElementProblem) || (element = ((IWodElementProblem)wodProblem).getElement()) == null || (htmlElementNames = htmlElementCache.getHtmlElementNames(element.getElementName())) == null) continue;
                    for (HtmlElementName htmlElementName : htmlElementNames) {
                        int lineNumber = WodHtmlUtils.getLineAtOffset(cache.getHtmlEntry().getContents(), htmlElementName.getStartOffset());
                        WodElementProblem htmlProblem = new WodElementProblem(element, "In the WOD, " + wodProblem.getMessage(), new Position(htmlElementName.getStartOffset(), htmlElementName.getEndOffset() - htmlElementName.getStartOffset() + 1), lineNumber, wodProblem.isWarning() || "warning".equals(wodErrorsInHtmlSeverity));
                        WodModelUtils.createMarker(htmlFile, (WodProblem)htmlProblem);
                    }
                }
            }
        }
    }

    @Override
    protected IWodModel _parse(String contents) {
        return null;
    }

    @Override
    protected IWodModel _parse(IDocument document, boolean updateCache) {
        IFile wodFile = this.getFile();
        IWodModel model = WodModelUtils.createWodModel(wodFile, document);
        this._setContents(document.get());
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IWodModel _parse(IFile file, boolean updateCache) throws Exception {
        IWodModel model;
        FileEditorInput input = new FileEditorInput(file);
        WodFileDocumentProvider provider = new WodFileDocumentProvider();
        provider.connect(input);
        try {
            IDocument document = provider.getDocument(input);
            model = (IWodModel)this.parse(document, updateCache);
        }
        finally {
            provider.disconnect(input);
        }
        return model;
    }
}

