/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.document;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.objectstyle.wolips.bindings.wod.AbstractWodElement;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.document.DocumentWodBinding;
import org.objectstyle.wolips.wodclipse.core.parser.RulePosition;

public class DocumentWodElement
extends AbstractWodElement {
    private RulePosition _elementName;
    private RulePosition _elementType;
    private int _endOffset;
    private int _lineNumber;

    public DocumentWodElement(RulePosition elementName, RulePosition elementType) {
        this._elementName = elementName;
        this._elementType = elementType;
        this._lineNumber = -1;
        this._endOffset = -1;
    }

    public String getElementName() {
        return this._elementName._getTextWithoutException();
    }

    public Position getElementNamePosition() {
        return this._elementName.getPosition();
    }

    public String getElementType() {
        return this._elementType._getTextWithoutException();
    }

    public Position getElementTypePosition() {
        return this._elementType.getPosition();
    }

    public int getNewBindingOffset() {
        int newBindingOffset = this.getEndOffset() - 1;
        return newBindingOffset;
    }

    public int getNewBindingIndent() {
        DocumentWodBinding lastBinding;
        RulePosition nameRulePosition;
        int indent = 2;
        List bindings = this.getBindings();
        if (bindings.size() > 0 && (nameRulePosition = (lastBinding = (DocumentWodBinding)((Object)bindings.get(bindings.size() - 1))).getNameRulePosition()) != null) {
            int startOffset = lastBinding.getStartOffset();
            try {
                IRegion lineInformation = nameRulePosition.getDocument().getLineInformationOfOffset(startOffset);
                indent = startOffset - lineInformation.getOffset();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return indent;
    }

    public int getStartOffset() {
        return this._elementName.getTokenOffset();
    }

    public int getEndOffset() {
        int endOffset = this._endOffset;
        if (endOffset == -1) {
            endOffset = this._elementType.getTokenEndOffset();
            for (IWodBinding binding : this.getBindings()) {
                endOffset = Math.max(endOffset, binding.getEndOffset());
            }
        }
        return endOffset;
    }

    public int getFullEndOffset() {
        return this.getEndOffset();
    }

    public void setEndOffset(int endOffset) {
        this._endOffset = endOffset;
    }

    public int getLineNumber() {
        int lineNumber = this._lineNumber;
        if (lineNumber == -1) {
            try {
                lineNumber = this._elementName.getDocument().getLineOfOffset(this._elementName.getTokenOffset());
            }
            catch (BadLocationException e) {
                Activator.getDefault().log(e);
            }
        }
        return lineNumber;
    }
}

