/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.util;

import java.util.Map;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.eclipse.jface.text.Position;
import org.objectstyle.wolips.bindings.api.ApiCache;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.SimpleWodBinding;
import org.objectstyle.wolips.bindings.wod.SimpleWodElement;
import org.objectstyle.wolips.bindings.wod.TagShortcut;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;

public class FuzzyXMLWodElement
extends SimpleWodElement {
    private FuzzyXMLElement _xmlElement;

    public FuzzyXMLWodElement(FuzzyXMLElement element, BuildProperties buildProperties) {
        FuzzyXMLAttribute[] attributes;
        String elementName = element.getName();
        String namespaceElementName = elementName.substring("wo:".length()).trim();
        int elementTypePosition = element.getOffset() + element.getNameOffset() + "wo:".length() + 1;
        int elementTypeLength = namespaceElementName.length();
        TagShortcut matchingTagShortcut = null;
        for (TagShortcut tagShortcut : ApiCache.getTagShortcuts()) {
            if (!namespaceElementName.equalsIgnoreCase(tagShortcut.getShortcut())) continue;
            matchingTagShortcut = tagShortcut;
        }
        if (matchingTagShortcut != null) {
            namespaceElementName = matchingTagShortcut.getActual();
        }
        this._setElementName("_temp");
        this._setElementType(namespaceElementName);
        this.setElementTypePosition(new Position(elementTypePosition, elementTypeLength));
        this.setInline(true);
        if (matchingTagShortcut != null) {
            for (Map.Entry entry : matchingTagShortcut.getAttributes().entrySet()) {
                WodHtmlUtils.BindingValue value = WodHtmlUtils.toBindingValue((String)entry.getValue(), buildProperties.getInlineBindingPrefix(), buildProperties.getInlineBindingSuffix());
                SimpleWodBinding wodBinding = new SimpleWodBinding(null, (String)entry.getKey(), value.getValue());
                this.addBinding((IWodBinding)wodBinding);
            }
        }
        for (FuzzyXMLAttribute attribute : attributes = element.getAttributes()) {
            Position valuePosition;
            String namespace = attribute.getNamespace();
            String name = attribute.getName();
            String originalValue = attribute.getValue();
            WodHtmlUtils.BindingValue value = WodHtmlUtils.toBindingValue(originalValue, buildProperties.getInlineBindingPrefix(), buildProperties.getInlineBindingSuffix());
            Position valueNamespacePosition = null;
            if (value.getValueNamespace() != null) {
                int valueNamespaceOffset = originalValue.indexOf(value.getValueNamespace());
                valueNamespacePosition = new Position(element.getOffset() + attribute.getValueDataOffset() + valueNamespaceOffset + 1, value.getValueNamespace().length());
                int valueOffset = originalValue.indexOf(value.getValue(), valueNamespaceOffset + value.getValueNamespace().length());
                valuePosition = new Position(valueNamespacePosition.offset + valueOffset, attribute.getValueDataLength() - valueOffset);
            } else {
                valuePosition = new Position(element.getOffset() + attribute.getValueDataOffset() + 1, attribute.getValueDataLength());
            }
            SimpleWodBinding wodBinding = new SimpleWodBinding(namespace, name, value.getValueNamespace(), value.getValue(), new Position(attribute.getNamespaceOffset(), attribute.getNamespaceLength()), new Position(attribute.getNameOffset(), attribute.getNameLength()), valueNamespacePosition, valuePosition, -1);
            wodBinding.setStartOffset(attribute.getOffset());
            wodBinding.setEndOffset(attribute.getOffset() + attribute.getLength());
            this.addBinding((IWodBinding)wodBinding);
        }
        this.setStartOffset(element.getOffset());
        this.setEndOffset(element.getOffset() + element.getOpenTagLength() + 2);
        if (element.hasCloseTag()) {
            this.setFullEndOffset(element.getCloseTagOffset() + element.getCloseTagLength() + 2);
        } else {
            this.setFullEndOffset(this.getEndOffset());
        }
        if (attributes.length > 0) {
            int n = attributes[attributes.length - 1].getOffset() + attributes[attributes.length - 1].getLength();
            this.setNewBindingOffset(n);
        } else {
            this.setNewBindingOffset(element.getOffset() + element.getNameOffset() + element.getNameLength() + 1);
        }
        this.setNewBindingIndent(1);
    }

    public FuzzyXMLElement getXmlElement() {
        return this._xmlElement;
    }
}

