/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eogenerator.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.objectstyle.wolips.eogenerator.core.model.IEOGeneratorListener;
import org.objectstyle.wolips.eogenerator.ui.dialogs.EOGeneratorResultsDialog;

public class DialogEOGeneratorListener
implements IEOGeneratorListener {
    private StringBuffer _output;
    private Shell _shell;
    private boolean _succeeded;

    public DialogEOGeneratorListener(Shell shell) {
        this._shell = shell;
    }

    public Shell getShell() {
        return this._shell;
    }

    public void eogeneratorStarted() {
        this._output = new StringBuffer();
        this._succeeded = true;
    }

    public void eogeneratorFailed(IFile eogenFile, String results) {
        this.appendLines(eogenFile, results);
        this._succeeded = false;
    }

    public void eogeneratorSucceeded(IFile eogenFile, String results) {
        this.appendLines(eogenFile, results);
    }

    public void eogeneratorFinished() {
        if (this._output.length() > 0 && !this._succeeded) {
            final String output = this._output.toString();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EOGeneratorResultsDialog resultsDialog = new EOGeneratorResultsDialog(DialogEOGeneratorListener.this.getShell(), output.toString());
                    resultsDialog.open();
                }
            });
        }
    }

    protected void appendLines(IFile eogenFile, String results) {
        this._output.append(eogenFile.getLocation().toOSString());
        this._output.append(":\n");
        if (results.length() == 0) {
            this._output.append("\tFinished.\n");
        } else {
            for (String line : results.split("\n")) {
                this._output.append("\t");
                this._output.append(line);
                this._output.append("\n");
            }
        }
        this._output.append("\n\n");
    }
}

