/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.ui.tags;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.objectstyle.wolips.jdt.ui.tags.Tag;
import org.objectstyle.wolips.jdt.ui.tags.TaggedComponent;

public class TagLib {
    public static final String FILENAME = ".wotaglib";
    private static final String TAG = "tag";
    private static final String COMPONENT = "component";
    public IProject project;
    private int lowestID = 0;
    private ArrayList<Tag> tagsList;
    private ArrayList<TaggedComponent> taggedComponentsList;

    public TagLib(IProject project) {
        this.project = project;
        this.read();
    }

    private void read() {
        this.tagsList = new ArrayList();
        this.taggedComponentsList = new ArrayList();
        Properties properties = new Properties();
        IFile iFile = this.project.getFile(FILENAME);
        if (iFile.exists() && iFile.isAccessible()) {
            File file = new File(iFile.getLocation().toOSString());
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.startsWith(TAG)) {
                String id = key.substring(key.indexOf(46) + 1);
                Integer idInteger = Integer.valueOf(id);
                String value = properties.getProperty(key);
                Tag tag = new Tag(this, idInteger, value);
                this.tagsList.add(tag);
                if (idInteger > this.lowestID) {
                    this.lowestID = idInteger;
                }
            }
            if (!key.startsWith(COMPONENT)) continue;
            String name = key.substring(key.indexOf(46) + 1);
            String idsString = properties.getProperty(key);
            StringTokenizer stringTokenizer = new StringTokenizer(idsString, ",");
            ArrayList<Integer> idsList = new ArrayList<Integer>();
            while (stringTokenizer.hasMoreTokens()) {
                String id = stringTokenizer.nextToken();
                Integer idInteger = Integer.valueOf(id);
                idsList.add(idInteger);
            }
            int[] ids = new int[idsList.size()];
            for (int i = 0; i < idsList.size(); ++i) {
                ids[i] = (Integer)idsList.get(i);
            }
            TaggedComponent taggedComponent = new TaggedComponent(this, name, ids);
            this.taggedComponentsList.add(taggedComponent);
        }
    }

    private void write() {
        Properties properties = new Properties();
        for (Tag tag : this.tagsList) {
            properties.put("tag." + tag.id, tag.name);
        }
        for (TaggedComponent taggedComponent : this.taggedComponentsList) {
            Object value = "";
            int[] ids = taggedComponent.ids;
            for (int i = 0; i < ids.length; ++i) {
                value = (String)value + ids[i];
                if (i == ids.length - 1) continue;
                value = (String)value + ",";
            }
            properties.put("component." + taggedComponent.name, value);
        }
        IFile iFile = this.project.getFile(FILENAME);
        File file = new File(iFile.getLocation().toOSString());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "wotaglib");
            iFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Tag[] getTags() {
        return this.tagsList.toArray(new Tag[this.tagsList.size()]);
    }

    public Tag[] getTags(Tag tag) {
        ArrayList<Tag> filteredTagsList = new ArrayList<Tag>();
        filteredTagsList.addAll(this.tagsList);
        filteredTagsList.remove(tag);
        return filteredTagsList.toArray(new Tag[filteredTagsList.size()]);
    }

    public TaggedComponent[] getComponents(Tag[] tags) {
        ArrayList<TaggedComponent> filteredTaggedComponentsList = new ArrayList<TaggedComponent>();
        for (TaggedComponent taggedComponent : this.taggedComponentsList) {
            int found = 0;
            for (int i = 0; i < taggedComponent.ids.length; ++i) {
                int id = taggedComponent.ids[i];
                for (int j = 0; j < tags.length; ++j) {
                    Tag tag = tags[j];
                    if (id != tag.id) continue;
                    ++found;
                }
            }
            if (found != tags.length) continue;
            filteredTaggedComponentsList.add(taggedComponent);
        }
        return filteredTaggedComponentsList.toArray(new TaggedComponent[filteredTaggedComponentsList.size()]);
    }

    private Tag getTag(String name) {
        for (Tag tag : this.tagsList) {
            if (!tag.name.equalsIgnoreCase(name)) continue;
            return tag;
        }
        ++this.lowestID;
        Tag tag = new Tag(this, this.lowestID, name);
        this.tagsList.add(tag);
        return tag;
    }

    private TaggedComponent getTaggedComponent(String name) {
        for (TaggedComponent taggedComponent : this.taggedComponentsList) {
            if (!taggedComponent.name.equalsIgnoreCase(name)) continue;
            return taggedComponent;
        }
        TaggedComponent taggedComponent = new TaggedComponent(this, name, new int[0]);
        this.taggedComponentsList.add(taggedComponent);
        return taggedComponent;
    }

    public void tagComponents(String[] componentNames, String tagName) {
        Tag tag = this.getTag(tagName);
        for (int i = 0; i < componentNames.length; ++i) {
            String componentName = componentNames[i];
            TaggedComponent taggedComponent = this.getTaggedComponent(componentName);
            taggedComponent.addTag(tag);
        }
        this.write();
    }
}

