/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLDocumentImpl;
import jp.aonir.fuzzyxml.internal.RenderContext;
import jp.aonir.fuzzyxml.internal.RenderDelegate;

public abstract class AbstractFuzzyXMLNode
implements FuzzyXMLNode {
    private int _offset = -1;
    private int _length = -1;
    private FuzzyXMLNode _parent;
    private FuzzyXMLDocumentImpl _doc;

    public AbstractFuzzyXMLNode() {
    }

    public AbstractFuzzyXMLNode(FuzzyXMLNode parent, int offset, int length) {
        this.setParentNode(parent);
        this.setOffset(offset);
        this.setLength(length);
    }

    public void setLength(int length) {
        this._length = length;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public int getOffset() {
        return this._offset;
    }

    @Override
    public FuzzyXMLNode getParentNode() {
        return this._parent;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public void setParentNode(FuzzyXMLNode parent) {
        this._parent = parent;
    }

    protected void fireModifyEvent(String newText, int offset, int length) {
        FuzzyXMLDocumentImpl doc = this.getDocument();
        if (doc == null) {
            return;
        }
        doc.fireModifyEvent(newText, offset, length);
    }

    protected void appendOffset(FuzzyXMLElement parent, int offset, int append) {
        FuzzyXMLDocumentImpl doc = this.getDocument();
        if (doc == null) {
            return;
        }
        doc.appendOffset(parent, offset, append);
    }

    public void setDocument(FuzzyXMLDocumentImpl doc) {
        this._doc = doc;
    }

    public FuzzyXMLDocumentImpl getDocument() {
        return this._doc;
    }

    @Override
    public String toXMLString(RenderContext renderContext) {
        StringBuffer xmlBuffer = new StringBuffer();
        RenderDelegate delegate = renderContext.getDelegate();
        if (delegate != null) {
            delegate.beforeRender(renderContext, xmlBuffer);
        }
        if (delegate == null || delegate.renderNode(this, renderContext, xmlBuffer)) {
            this.toXMLString(renderContext, xmlBuffer);
        }
        if (delegate != null) {
            delegate.afterRender(renderContext, xmlBuffer);
        }
        return xmlBuffer.toString();
    }

    public boolean isNonBreaking() {
        return true;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean hasLineBreaks() {
        return true;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }
}

