/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.dtdeditor.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;

public class DTDAssistProcessor
extends HTMLAssistProcessor {
    private static final int UNDEF = 0;
    private static final int ELEMENT_ELEMENT = 1;
    private static final int ELEMENT_TYPE = 2;
    private static final int ELEMENT_CONTENT = 3;
    private static final int ATTLIST_ELEMENT = 4;
    private static final int ATTLIST_ATTRNAME = 5;
    private static final int ATTLIST_ATTRTYPE = 6;
    private static final int ATTLIST_ATTROMIT = 7;
    private static String[] DECLS = new String[]{"ELEMENT", "ATTLIST", "ENTITY", "NOTATION"};
    private static String[] ATTR_TYPES = new String[]{"CDATA", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS"};
    private static String[] ATTR_OMITS = new String[]{"#REQUIRED", "#IMPLIED", "#FIXED \"\"", "\"\""};
    private static String[] ELEM_TYPES = new String[]{"ANY", "EMPTY", "(#PCDATA)", "()"};
    private Pattern elementPattern = Pattern.compile("<!ELEMENT\\s+(.*?)\\s");
    private Pattern entityPattern = Pattern.compile("<!ENTITY\\s+%\\s(.*?)\\s");
    private List<String> elements = new ArrayList<String>();
    private List<String> entities = new ArrayList<String>();

    @Override
    public void update(HTMLSourceEditor editor, String source) {
        this.elements.clear();
        source = FuzzyXMLUtil.comment2space(source, false);
        Matcher matcher = this.elementPattern.matcher(source);
        while (matcher.find()) {
            this.elements.add(matcher.group(1).trim());
        }
        this.entities.clear();
        matcher = this.entityPattern.matcher(source);
        while (matcher.find()) {
            this.entities.add("%" + matcher.group(1).trim());
        }
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        int i;
        String text = FuzzyXMLUtil.comment2space(viewer.getDocument().get(), false);
        text = text.substring(0, documentOffset);
        String word = this.getWord(text);
        int context = this.getContext(text);
        ArrayList<ICompletionProposal> list = new ArrayList<ICompletionProposal>();
        if (word.startsWith("<") || context == 0) {
            for (i = 0; i < DECLS.length; ++i) {
                if (!("<!" + DECLS[i]).startsWith(word)) continue;
                list.add((ICompletionProposal)DTDAssistProcessor.createProposal("<!" + DECLS[i] + " >", "<!" + DECLS[i] + " ... >", word, documentOffset, DECLS[i].length() + 3, "_icon_tag"));
            }
        } else if (context == 4 || context == 3) {
            for (i = 0; i < this.elements.size(); ++i) {
                String element = this.elements.get(i);
                if (!element.startsWith(word)) continue;
                list.add((ICompletionProposal)DTDAssistProcessor.createProposal(element, element, word, documentOffset, element.length(), "_icon_element"));
            }
        } else if (context == 6) {
            for (i = 0; i < ATTR_TYPES.length; ++i) {
                if (!ATTR_TYPES[i].startsWith(word)) continue;
                list.add((ICompletionProposal)DTDAssistProcessor.createProposal(ATTR_TYPES[i], ATTR_TYPES[i], word, documentOffset, ATTR_TYPES[i].length(), "_icon_value"));
            }
            for (i = 0; i < this.entities.size(); ++i) {
                String value = this.entities.get(i);
                if (!value.startsWith(word)) continue;
                list.add((ICompletionProposal)DTDAssistProcessor.createProposal(value, value, word, documentOffset, value.length(), "_icon_value"));
            }
        } else if (context == 7) {
            for (i = 0; i < ATTR_OMITS.length; ++i) {
                if (!ATTR_OMITS[i].startsWith(word) || word.startsWith("\"")) continue;
                int position = ATTR_OMITS[i].indexOf(34);
                position = position < 0 ? ATTR_OMITS[i].length() : ++position;
                list.add((ICompletionProposal)DTDAssistProcessor.createProposal(ATTR_OMITS[i], ATTR_OMITS[i], word, documentOffset, position, "_icon_value"));
            }
        } else if (context == 2) {
            for (i = 0; i < ELEM_TYPES.length; ++i) {
                if (!ELEM_TYPES[i].startsWith(word)) continue;
                int position = ELEM_TYPES[i].length();
                if (ELEM_TYPES[i].equals("()")) {
                    position = 1;
                }
                list.add((ICompletionProposal)DTDAssistProcessor.createProposal(ELEM_TYPES[i], ELEM_TYPES[i], word, documentOffset, position, "_icon_value"));
            }
        }
        HTMLUtil.sortCompilationProposal(list);
        ICompletionProposal[] prop = list.toArray(new ICompletionProposal[list.size()]);
        return prop;
    }

    private static CompletionProposal createProposal(String text, String display, String word, int offset, int position, String image) {
        return new CompletionProposal(text, offset - word.length(), word.length(), position, HTMLPlugin.getDefault().getImageRegistry().get(image), display, null, null);
    }

    protected String getWord(String text) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c) || c == '(' || c == ')' || c == '|' || c == ',') {
                if (sb.length() <= 0) continue;
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected int getContext(String text) {
        StringBuffer sb = new StringBuffer();
        int context = 0;
        boolean flag = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if ((Character.isWhitespace(c) || c == '(' || c == ')') && !flag) {
                if (c == '(' || c == ')') {
                    sb.append(c);
                }
                if (sb.length() <= 0) continue;
                context = this.judgeContext(sb.toString(), context);
                sb.setLength(0);
                continue;
            }
            if (c == '\"') {
                flag = !flag;
            }
            sb.append(c);
        }
        return context;
    }

    private int judgeContext(String word, int prev) {
        if (word.equals("<!ELEMENT")) {
            return 1;
        }
        if (word.equals("<!ATTLIST")) {
            return 4;
        }
        if (word.startsWith("<!")) {
            return 0;
        }
        if (prev == 1) {
            return 2;
        }
        if (prev == 2 && word.equals("(")) {
            return 3;
        }
        if (prev == 3 && !word.endsWith(")")) {
            return 3;
        }
        if (prev == 4) {
            return 5;
        }
        if (prev == 5) {
            return 6;
        }
        if (prev == 6) {
            return 7;
        }
        if (prev == 7) {
            if (word.startsWith("#FIXED")) {
                return 7;
            }
            return 5;
        }
        return 0;
    }

    @Override
    public boolean enableTemplate() {
        return false;
    }
}

