/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.assist;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.IFileAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;

public class FileAssistProcessor
implements IFileAssistProcessor {
    private IFile _file;

    @Override
    public void reload(IFile file) {
        this._file = file;
    }

    @Override
    public AssistInfo[] getAssistInfo(String value) {
        int index;
        IPath path = null;
        Object parent = null;
        if (value.startsWith("/")) {
            return new AssistInfo[0];
        }
        if (path == null) {
            path = this._file.getParent().getProjectRelativePath();
        }
        if ((index = value.lastIndexOf(47)) >= 0) {
            path = path.append(value.substring(0, index));
            parent = value.substring(0, index) + "/";
        } else {
            parent = "";
        }
        IResource resource = this._file.getProject().findMember(path);
        if (resource != null && resource.exists() && resource instanceof IContainer) {
            try {
                IContainer container = (IContainer)resource;
                IResource[] children = container.members();
                ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
                for (int i = 0; i < children.length; ++i) {
                    if (children[i].getName().startsWith(".") || children[i].getName().equals("WEB-INF") || ((String)parent).indexOf("WEB-INF") >= 0) continue;
                    Image image = null;
                    image = children[i] instanceof IContainer ? HTMLPlugin.getDefault().getImageRegistry().get("_icon_folder") : this.getFileImage(children[i].getName().toLowerCase());
                    list.add(new AssistInfo((String)parent + children[i].getName(), children[i].getName(), image));
                }
                return list.toArray(new AssistInfo[list.size()]);
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        return new AssistInfo[0];
    }

    private Image getFileImage(String name) {
        if (name.endsWith(".html") || name.endsWith(".htm") || name.endsWith(".shtml")) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_html");
        }
        if (name.endsWith(".xml") || name.endsWith(".xhtml") || name.equals(".tld")) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_xml");
        }
        if (name.endsWith(".jsp")) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_jsp");
        }
        if (name.endsWith(".css")) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_css");
        }
        for (int i = 0; i < HTMLPlugin.SUPPORTED_IMAGE_TYPES.length; ++i) {
            if (!name.endsWith("." + HTMLPlugin.SUPPORTED_IMAGE_TYPES[i])) continue;
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_web");
        }
        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_file");
    }
}

