/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;

public class TagRule
extends MultiLineRule {
    public TagRule(IToken token) {
        super("<", ">", token);
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        if (sequence[0] == '<') {
            int c = scanner.read();
            if (c == 63 || c == 33 || c == 37) {
                scanner.unread();
                return false;
            }
        } else if (sequence[0] == '>') {
            scanner.unread();
            scanner.unread();
            int c = scanner.read();
            scanner.read();
            if (c == 37) {
                return false;
            }
        }
        return super.sequenceDetected(scanner, sequence, eofAllowed);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        boolean doubleQuoted = false;
        boolean singleQuoted = false;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        boolean previousWasEscapeCharacter = false;
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                scanner.read();
            } else if (c == 34) {
                if (!singleQuoted) {
                    doubleQuoted = !doubleQuoted;
                }
            } else if (c == 39) {
                if (!doubleQuoted) {
                    singleQuoted = !singleQuoted;
                }
            } else if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (!doubleQuoted && !singleQuoted && this.sequenceDetected(scanner, this.fEndSequence, true)) {
                    return true;
                }
            } else if (this.fBreaksOnEOL) {
                for (int i = 0; i < delimiters.length; ++i) {
                    if (c != delimiters[i][0] || !this.sequenceDetected(scanner, delimiters[i], true) || this.fEscapeContinuesLine && previousWasEscapeCharacter) continue;
                    return true;
                }
            }
            previousWasEscapeCharacter = c == this.fEscapeCharacter;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        scanner.unread();
        return false;
    }
}

