/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.eomodeler.Activator;

public class OpenEntityModelerAction
implements IObjectActionDelegate {
    private IResource _actionResource;
    private IWorkbenchPart _part;

    public void dispose() {
        this._actionResource = null;
    }

    public void run(IAction action) {
        OpenEntityModelerAction.openResourceIfPossible(this._part, this._actionResource);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        this._actionResource = null;
        if (obj != null && obj instanceof IResource) {
            this._actionResource = (IResource)obj;
        }
        if (obj != null && obj instanceof IProject) {
            this._actionResource = (IProject)obj;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this._part = targetPart;
    }

    public static boolean openResourceIfPossible(IWorkbenchPart part, IResource actionResource) {
        IWorkbenchWindow existingWindow = part == null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow() : part.getSite().getWorkbenchWindow();
        IWorkbench workbench = existingWindow.getWorkbench();
        boolean opened = false;
        if (actionResource != null) {
            IFile editorFile = null;
            if (actionResource.getName().endsWith(".eomodeld") && actionResource instanceof IFolder) {
                IFolder eomodeldFolder = (IFolder)actionResource;
                editorFile = eomodeldFolder.getFile("index.eomodeld");
            } else if (actionResource.getName().equals("index.eomodeld") && actionResource instanceof IFile) {
                editorFile = (IFile)actionResource;
            } else if (actionResource.getName().endsWith(".plist") && actionResource instanceof IFile && actionResource.getParent().getFile((IPath)new Path("index.eomodeld")).exists()) {
                editorFile = (IFile)actionResource;
            }
            if (editorFile != null && editorFile.exists()) {
                FileEditorInput input = new FileEditorInput(editorFile);
                IEditorPart editorPart = null;
                for (IWorkbenchWindow window : workbench.getWorkbenchWindows()) {
                    for (IWorkbenchPage page : window.getPages()) {
                        if (editorPart != null) continue;
                        editorPart = page.findEditor((IEditorInput)input);
                    }
                }
                if (editorPart != null) {
                    IWorkbenchPage page = editorPart.getEditorSite().getPage();
                    IWorkbenchWindow window = page.getWorkbenchWindow();
                    window.setActivePage(page);
                    window.getShell().setActive();
                    opened = true;
                } else if (Activator.getDefault().getPreferenceStore().getBoolean("EntityModelerOpenInWindow")) {
                    try {
                        IWorkbenchWindow window = workbench.openWorkbenchWindow("org.objectstyle.wolips.eomodeler.EOModelerPerspective", null);
                        window.getActivePage().openEditor((IEditorInput)new FileEditorInput(editorFile), "org.objectstyle.wolips.eomodeler.editors.EOModelEditor");
                        window.getPartService().addPartListener(new IPartListener(){

                            public void partOpened(final IWorkbenchPart part) {
                                if ("org.eclipse.ui.console.ConsoleView".equals(part.getSite().getId())) {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            part.getSite().getPage().hideView((IViewPart)part);
                                        }
                                    });
                                }
                            }

                            public void partDeactivated(IWorkbenchPart part) {
                            }

                            public void partClosed(IWorkbenchPart part) {
                            }

                            public void partBroughtToTop(IWorkbenchPart part) {
                            }

                            public void partActivated(IWorkbenchPart part) {
                            }
                        });
                        opened = true;
                    }
                    catch (WorkbenchException e) {
                        Activator.getDefault().log(e);
                    }
                } else {
                    try {
                        IDE.openEditor((IWorkbenchPage)existingWindow.getActivePage(), (IFile)editorFile, (String)"org.objectstyle.wolips.eomodeler.editors.EOModelEditor");
                    }
                    catch (PartInitException e) {
                        Activator.getDefault().log(e);
                    }
                }
            }
        }
        return opened;
    }
}

