/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.kvc;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.objectstyle.wolips.eomodeler.core.kvc.FieldKey;
import org.objectstyle.wolips.eomodeler.core.kvc.IKey;
import org.objectstyle.wolips.eomodeler.core.kvc.MapKey;
import org.objectstyle.wolips.eomodeler.core.kvc.MethodKey;

public class MemberContainer {
    public static final int GET = 1;
    public static final int SET = 2;
    private static final String[] GET_METHOD_PREFIXES = new String[]{"get", "", "_", "_get", "is", "_is"};
    private static final String[] SET_METHOD_PREFIXES = new String[]{"set", "", "_", "_set"};
    private static final String[] FIELD_PREFIXES = new String[]{"", "_"};
    private int myMemberType;
    private Class myClass;
    private Map<String, IKey> myMembers = new HashMap<String, IKey>();

    public MemberContainer(Class _class, int _memberType) {
        Class currentClass;
        this.myClass = _class;
        this.myMemberType = _memberType;
        for (currentClass = _class; currentClass != null; currentClass = currentClass.getSuperclass()) {
            this.hashMembers(currentClass.getDeclaredFields());
        }
        for (currentClass = _class; currentClass != null; currentClass = currentClass.getSuperclass()) {
            this.hashMembers(currentClass.getDeclaredMethods());
        }
    }

    public IKey getMember(Object _instance, String _name) {
        String[] prefixes = this.myMemberType == 1 ? GET_METHOD_PREFIXES : SET_METHOD_PREFIXES;
        IKey setMember = this.getMemberWithPrefixes(_name, prefixes);
        if (setMember == null && (setMember = this.getMemberWithPrefixes(_name, FIELD_PREFIXES)) == null) {
            if (_instance instanceof Map) {
                setMember = new MapKey(_name);
            } else {
                if (this.myMemberType == 1) {
                    throw new IllegalArgumentException("There is no get-method named '" + _name + "' on the class " + this.myClass.getName() + ".");
                }
                throw new IllegalArgumentException("There is no set-method named '" + _name + "' on the class " + this.myClass.getName() + ".");
            }
        }
        return setMember;
    }

    protected void hashMembers(Member[] _members) {
        for (int memberNum = 0; memberNum < _members.length; ++memberNum) {
            Method method;
            Member member = _members[memberNum];
            int modifiers = member.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            IKey matchingMember = null;
            if (this.myMemberType == 1) {
                if (member instanceof Field) {
                    matchingMember = new FieldKey((Field)member);
                } else {
                    method = (Method)member;
                    if (method.getReturnType() != null && method.getParameterTypes().length == 0) {
                        matchingMember = new MethodKey(method);
                    }
                }
            } else if (this.myMemberType == 2) {
                if (member instanceof Field) {
                    matchingMember = new FieldKey((Field)member);
                } else {
                    method = (Method)member;
                    if (method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1) {
                        matchingMember = new MethodKey(method);
                    }
                }
            }
            if (matchingMember == null) continue;
            this.myMembers.put(member.getName(), matchingMember);
        }
    }

    protected IKey getMemberWithPrefixes(String _key, String[] _prefixes) {
        IKey matchingMember = null;
        for (int prefixNum = 0; matchingMember == null && prefixNum < _prefixes.length; ++prefixNum) {
            String prefix = _prefixes[prefixNum];
            boolean capitalize = prefix.length() > 1;
            String keyWithPrefix = this.prependToKey(prefix, _key, capitalize);
            matchingMember = this.myMembers.get(keyWithPrefix);
        }
        return matchingMember;
    }

    protected String prependToKey(String _prepend, String _key, boolean _capitalize) {
        StringBuffer sb = new StringBuffer();
        sb.append(_prepend);
        if (_capitalize) {
            sb.append(Character.toUpperCase(_key.charAt(0)));
            sb.append(_key.substring(1));
        } else {
            sb.append(_key);
        }
        return sb.toString();
    }
}

