/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.IEOClassLoaderFactory;
import org.osgi.framework.Bundle;

public abstract class AbstractEOClassLoader
implements IEOClassLoaderFactory {
    private static Map<String, Reference<ClassLoader>> CLASSLOADER_CACHE = new HashMap<String, Reference<ClassLoader>>();

    @Override
    public ClassLoader createClassLoaderForModel(EOModel model) throws EOModelException {
        try {
            URL wo56sqlJarUrl;
            URL wo53sqlJarUrl;
            LinkedHashSet<URL> classpathSet = new LinkedHashSet<URL>();
            this.fillInModelClasspath(model, classpathSet);
            this.fillInDevelopmentClasspath(classpathSet);
            Bundle bundle = InternalPlatform.getDefault().getBundle("org.objectstyle.wolips.eomodeler.core");
            URL wosqlJarUrl = bundle.getEntry("/lib/EOFSQLUtils.jar");
            if (wosqlJarUrl != null) {
                classpathSet.add(wosqlJarUrl);
            }
            if ((wo53sqlJarUrl = bundle.getEntry("/lib/EOFSQLUtils53.jar")) != null) {
                classpathSet.add(wo53sqlJarUrl);
            }
            if ((wo56sqlJarUrl = bundle.getEntry("/lib/EOFSQLUtils56.jar")) != null) {
                classpathSet.add(wo56sqlJarUrl);
            }
            StringBuffer webobjectsClasspath = new StringBuffer();
            for (URL classpathUrl : classpathSet) {
                webobjectsClasspath.append(File.pathSeparator);
                webobjectsClasspath.append(classpathUrl.getPath());
            }
            System.setProperty("com.webobjects.classpath", webobjectsClasspath.toString());
            System.setProperty("NSProjectBundleEnabled", "true");
            ClassLoader eomodelClassLoader = this.createEOModelClassLoader(model, classpathSet);
            return eomodelClassLoader;
        }
        catch (Exception e) {
            throw new EOModelException("Failed to create EOF class loader.", e);
        }
    }

    protected synchronized ClassLoader createEOModelClassLoader(EOModel model, Set<URL> classpathUrlSet) {
        URLClassLoader classLoader = null;
        String cacheKey = this.getCacheKey(model, classpathUrlSet);
        Reference<ClassLoader> classLoaderReference = CLASSLOADER_CACHE.get(cacheKey);
        if (classLoaderReference != null && (classLoader = (URLClassLoader)classLoaderReference.get()) != null) {
            LinkedHashSet<URL> previousURLSet = new LinkedHashSet<URL>();
            for (URL previousURL : classLoader.getURLs()) {
                previousURLSet.add(previousURL);
            }
            if (!previousURLSet.equals(classpathUrlSet)) {
                classLoader = null;
            }
        }
        if (classLoader == null) {
            if (classpathUrlSet.size() == 1) {
                classLoader = null;
            } else {
                URL[] classpathUrls = classpathUrlSet.toArray(new URL[classpathUrlSet.size()]);
                classLoader = URLClassLoader.newInstance(classpathUrls);
                CLASSLOADER_CACHE.put(cacheKey, new SoftReference<URLClassLoader>(classLoader));
            }
        }
        return classLoader;
    }

    protected String getCacheKey(EOModel model, Set<URL> classpathUrlSet) {
        return model.getName() + "_" + String.valueOf(classpathUrlSet.hashCode());
    }

    protected abstract void fillInModelClasspath(EOModel var1, Set<URL> var2) throws Exception;

    protected abstract void fillInDevelopmentClasspath(Set<URL> var1) throws Exception;
}

