/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.fetchspec;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;
import org.objectstyle.wolips.eomodeler.editors.storedProcedures.EOStoredProceduresConstants;
import org.objectstyle.wolips.eomodeler.editors.storedProcedures.EOStoredProceduresContentProvider;
import org.objectstyle.wolips.eomodeler.utils.FormUtils;
import org.objectstyle.wolips.eomodeler.utils.TablePropertyLabelProvider;
import org.objectstyle.wolips.eomodeler.utils.TablePropertyViewerSorter;
import org.objectstyle.wolips.eomodeler.utils.TableRefreshPropertyListener;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class EOFetchSpecSQLEditorSection
extends AbstractPropertySection
implements ISelectionChangedListener,
SelectionListener {
    private EOFetchSpecification _fetchSpecification;
    private Text _rawSQLText;
    private TableViewer _storedProcedureTableViewer;
    private TableRefreshPropertyListener _storedProcedureChangedRefresher;
    private StoredProcedureChangedHandler _storedProcedureChangedHandler = new StoredProcedureChangedHandler();
    private Button _useQualifierButton;
    private Button _useRawSQLButton;
    private Button _useStoredProcedureButton;
    private DataBindingContext _bindingContext;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite form = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout formLayout = new FormLayout();
        form.setLayout((Layout)formLayout);
        Composite topForm = FormUtils.createForm(this.getWidgetFactory(), form, 1);
        this._useQualifierButton = new Button(topForm, 16);
        this._useQualifierButton.setText(Messages.getString("EOFetchSpecSQLEditorSection.useQualifier"));
        this._useRawSQLButton = new Button(topForm, 16);
        this._useRawSQLButton.setText(Messages.getString("EOFetchSpecSQLEditorSection.useRawSQL"));
        this._rawSQLText = new Text(topForm, 2048);
        GridData nameLayoutData = new GridData(768);
        this._rawSQLText.setLayoutData((Object)nameLayoutData);
        this._useStoredProcedureButton = new Button(topForm, 16);
        this._useStoredProcedureButton.setText(Messages.getString("EOFetchSpecSQLEditorSection.useStoredProcedure"));
        this._storedProcedureTableViewer = TableUtils.createTableViewer(topForm, "EOStoredProcedure", EOStoredProceduresConstants.COLUMNS, (IStructuredContentProvider)new EOStoredProceduresContentProvider(), (ITableLabelProvider)new TablePropertyLabelProvider(EOStoredProceduresConstants.COLUMNS), (ViewerSorter)new TablePropertyViewerSorter(EOStoredProceduresConstants.COLUMNS));
        GridData rawRowKeyPathsTableLayoutData = new GridData(1808);
        rawRowKeyPathsTableLayoutData.heightHint = 100;
        this._storedProcedureTableViewer.getTable().setLayoutData((Object)rawRowKeyPathsTableLayoutData);
        this._storedProcedureTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this._storedProcedureChangedRefresher = new TableRefreshPropertyListener("StoredProcedureChanged", this._storedProcedureTableViewer);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (ComparisonUtils.equals((Object)selection, (Object)this.getSelection())) {
            return;
        }
        super.setInput(part, selection);
        this.disposeBindings();
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        this._fetchSpecification = (EOFetchSpecification)selectedObject;
        if (this._fetchSpecification != null) {
            this.addBindings();
            this._storedProcedureTableViewer.setInput((Object)this._fetchSpecification);
            TableUtils.packTableColumns(this._storedProcedureTableViewer);
            this.updateButtonsEnabled();
        }
    }

    protected void addBindings() {
        if (this._fetchSpecification != null) {
            this._bindingContext = new DataBindingContext();
            this._bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this._rawSQLText), BeanProperties.value((String)"customQueryExpression").observe((Object)this._fetchSpecification), null, null);
            this._fetchSpecification.getEntity().getModel().addPropertyChangeListener("storedProcedures", this._storedProcedureChangedRefresher);
            this._fetchSpecification.getEntity().getModel().addPropertyChangeListener("storedProcedure", this._storedProcedureChangedRefresher);
            this._fetchSpecification.addPropertyChangeListener("storedProcedure", this._storedProcedureChangedHandler);
            this._fetchSpecification.addPropertyChangeListener("customQueryExpression", this._storedProcedureChangedHandler);
        }
    }

    protected void disposeBindings() {
        if (this._bindingContext != null) {
            this._bindingContext.dispose();
        }
        if (this._fetchSpecification != null) {
            this._fetchSpecification.getEntity().getModel().removePropertyChangeListener("storedProcedures", this._storedProcedureChangedRefresher);
            this._fetchSpecification.getEntity().getModel().removePropertyChangeListener("storedProcedure", this._storedProcedureChangedRefresher);
            this._fetchSpecification.removePropertyChangeListener("storedProcedure", this._storedProcedureChangedHandler);
            this._fetchSpecification.removePropertyChangeListener("customQueryExpression", this._storedProcedureChangedHandler);
        }
    }

    protected void removeButtonListeners() {
        this._useQualifierButton.removeSelectionListener((SelectionListener)this);
        this._useRawSQLButton.removeSelectionListener((SelectionListener)this);
        this._useStoredProcedureButton.removeSelectionListener((SelectionListener)this);
    }

    protected void addButtonListeners() {
        this._useQualifierButton.addSelectionListener((SelectionListener)this);
        this._useRawSQLButton.addSelectionListener((SelectionListener)this);
        this._useStoredProcedureButton.addSelectionListener((SelectionListener)this);
    }

    public void dispose() {
        super.dispose();
        this.disposeBindings();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        Button source = (Button)event.getSource();
        if (source.getSelection()) {
            Iterator<EOStoredProcedure> storedProceduresIter;
            this.disposeBindings();
            if (source == this._useQualifierButton) {
                this._fetchSpecification.useQualifier();
            } else if (source == this._useRawSQLButton) {
                this._fetchSpecification.useCustomQueryExpression();
            } else if (source == this._useStoredProcedureButton && (storedProceduresIter = this._fetchSpecification.getEntity().getModel().getStoredProcedures().iterator()).hasNext()) {
                EOStoredProcedure storedProcedure = storedProceduresIter.next();
                this._fetchSpecification.setStoredProcedure(storedProcedure);
            }
            this.updateButtonsEnabled();
            this.addBindings();
        }
    }

    public void updateButtonsEnabled() {
        this.removeButtonListeners();
        this._useQualifierButton.setSelection(this._fetchSpecification.isUsingQualifier());
        this._useRawSQLButton.setSelection(this._fetchSpecification.isUsingCustomQuery());
        this._useStoredProcedureButton.setSelection(this._fetchSpecification.isUsingStoredProcedure());
        this._rawSQLText.setEnabled(this._fetchSpecification.isUsingCustomQuery());
        if (!this._fetchSpecification.isUsingStoredProcedure() && !this._storedProcedureTableViewer.getSelection().isEmpty()) {
            this._storedProcedureTableViewer.setSelection((ISelection)new StructuredSelection());
            this._storedProcedureTableViewer.getTable().setEnabled(false);
        } else if (this._fetchSpecification.isUsingStoredProcedure()) {
            this._storedProcedureTableViewer.getTable().setEnabled(true);
            this._storedProcedureTableViewer.setSelection((ISelection)new StructuredSelection((Object)this._fetchSpecification.getStoredProcedure()));
        }
        this.addButtonListeners();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        EOStoredProcedure storedProcedure = (EOStoredProcedure)selection.getFirstElement();
        this._fetchSpecification.setStoredProcedure(storedProcedure);
    }

    protected class StoredProcedureChangedHandler
    implements PropertyChangeListener {
        protected StoredProcedureChangedHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            EOFetchSpecSQLEditorSection.this.updateButtonsEnabled();
        }
    }
}

