/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.relationships;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.TableRowDoubleClickHandler;
import org.objectstyle.wolips.baseforuiplugins.utils.WOTextCellEditor;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.UserInfoableEOModelObject;
import org.objectstyle.wolips.eomodeler.editors.relationships.EORelationshipsCellModifier;
import org.objectstyle.wolips.eomodeler.editors.relationships.EORelationshipsContentProvider;
import org.objectstyle.wolips.eomodeler.editors.relationships.EORelationshipsLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.relationships.EORelationshipsViewerSorter;
import org.objectstyle.wolips.eomodeler.utils.StayEditingCellEditorListener;
import org.objectstyle.wolips.eomodeler.utils.TableRefreshPropertyListener;
import org.objectstyle.wolips.eomodeler.utils.TableRowRefreshPropertyListener;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class EORelationshipsTableViewer
extends Composite
implements ISelectionProvider {
    private TableViewer myRelationshipsTableViewer;
    private EOEntity myEntity;
    private TableRefreshPropertyListener myRelationshipsChangedRefresher;
    private TableRefreshPropertyListener myParentChangedRefresher;
    private TableRowRefreshPropertyListener myTableRowRefresher;
    private List<ISelectionChangedListener> mySelectionListeners;

    public EORelationshipsTableViewer(Composite _parent, int _style) {
        super(_parent, _style);
        TableColumn allowNullColumn;
        TableColumn classPropertyColumn;
        this.setLayout((Layout)new FillLayout());
        this.mySelectionListeners = new LinkedList<ISelectionChangedListener>();
        this.myRelationshipsTableViewer = TableUtils.createTableViewer((Composite)this, 65538, "EORelationship", EORelationship.class.getName(), (IStructuredContentProvider)new EORelationshipsContentProvider(), null, (ViewerSorter)new EORelationshipsViewerSorter(EORelationship.class.getName()));
        this.myRelationshipsTableViewer.setLabelProvider((IBaseLabelProvider)new EORelationshipsLabelProvider(this.myRelationshipsTableViewer, EORelationship.class.getName()));
        new DoubleClickNewRelationshipHandler(this.myRelationshipsTableViewer).attach();
        this.myRelationshipsChangedRefresher = new TableRefreshPropertyListener("RelationshipsChanged", this.myRelationshipsTableViewer);
        this.myParentChangedRefresher = new TableRefreshPropertyListener("EntityParentChanged", this.myRelationshipsTableViewer);
        this.myTableRowRefresher = new TableRowRefreshPropertyListener(this.myRelationshipsTableViewer);
        Table relationshipsTable = this.myRelationshipsTableViewer.getTable();
        relationshipsTable.setLayoutData((Object)new GridData(1808));
        TableColumn toManyColumn = TableUtils.getColumn(this.myRelationshipsTableViewer, EORelationship.class.getName(), "toMany");
        if (toManyColumn != null) {
            toManyColumn.setText("");
        }
        if ((classPropertyColumn = TableUtils.getColumn(this.myRelationshipsTableViewer, EORelationship.class.getName(), "classProperty")) != null) {
            classPropertyColumn.setText("");
            classPropertyColumn.setImage(Activator.getDefault().getImageRegistry().get("classProperty"));
        }
        if ((allowNullColumn = TableUtils.getColumn(this.myRelationshipsTableViewer, EORelationship.class.getName(), "optional")) != null) {
            allowNullColumn.setText("");
            allowNullColumn.setImage(Activator.getDefault().getImageRegistry().get("allowNull"));
        }
        TableUtils.sort(this.myRelationshipsTableViewer, "name");
        CellEditor[] cellEditors = new CellEditor[TableUtils.getColumnsForTableNamed(EORelationship.class.getName()).length];
        TableUtils.setCellEditor(EORelationship.class.getName(), "toMany", (CellEditor)new CheckboxCellEditor(), cellEditors);
        TableUtils.setCellEditor(EORelationship.class.getName(), "classProperty", (CellEditor)new CheckboxCellEditor(), cellEditors);
        TableUtils.setCellEditor(EORelationship.class.getName(), "optional", (CellEditor)new CheckboxCellEditor(), cellEditors);
        TableUtils.setCellEditor(EORelationship.class.getName(), "name", (CellEditor)new WOTextCellEditor((Composite)relationshipsTable), cellEditors);
        this.myRelationshipsTableViewer.setCellModifier((ICellModifier)new EORelationshipsCellModifier(this.myRelationshipsTableViewer));
        this.myRelationshipsTableViewer.setCellEditors(cellEditors);
        new StayEditingCellEditorListener(this.myRelationshipsTableViewer, EORelationship.class.getName(), "name");
    }

    public void setEntity(EOEntity _entity) {
        if (this.myEntity != null) {
            this.myRelationshipsChangedRefresher.stop();
            this.myEntity.removePropertyChangeListener("parent", this.myParentChangedRefresher);
            this.myEntity.removePropertyChangeListener("relationships", this.myRelationshipsChangedRefresher);
            this.myEntity.removePropertyChangeListener("relationship", this.myTableRowRefresher);
        }
        this.myEntity = _entity;
        if (this.myEntity != null) {
            this.myRelationshipsTableViewer.setInput((Object)this.myEntity);
            TableUtils.packTableColumns(this.myRelationshipsTableViewer);
            TableColumn nameColumn = TableUtils.getColumn(this.myRelationshipsTableViewer, EORelationship.class.getName(), "name");
            if (nameColumn != null) {
                nameColumn.setWidth(Math.max(nameColumn.getWidth(), 100));
            }
            this.myEntity.addPropertyChangeListener("parent", this.myParentChangedRefresher);
            this.myRelationshipsChangedRefresher.start();
            this.myEntity.addPropertyChangeListener("relationships", this.myRelationshipsChangedRefresher);
            this.myEntity.addPropertyChangeListener("relationship", this.myTableRowRefresher);
        }
    }

    public void dispose() {
        this.myRelationshipsChangedRefresher.stop();
        super.dispose();
    }

    public EOEntity getEntity() {
        return this.myEntity;
    }

    public TableViewer getTableViewer() {
        return this.myRelationshipsTableViewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener _listener) {
        this.myRelationshipsTableViewer.addSelectionChangedListener(_listener);
        this.mySelectionListeners.add(_listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener _listener) {
        this.myRelationshipsTableViewer.removeSelectionChangedListener(_listener);
        this.mySelectionListeners.remove(_listener);
    }

    public ISelection getSelection() {
        return this.myRelationshipsTableViewer.getSelection();
    }

    public void setSelection(ISelection _selection) {
        this.myRelationshipsTableViewer.setSelection(_selection);
    }

    protected List getSelectionListeners() {
        return this.mySelectionListeners;
    }

    protected TableViewer getRelationshipsTableViewer() {
        return this.myRelationshipsTableViewer;
    }

    protected class DoubleClickNewRelationshipHandler
    extends TableRowDoubleClickHandler {
        public DoubleClickNewRelationshipHandler(TableViewer _viewer) {
            super(_viewer);
        }

        protected void emptyDoubleSelectionOccurred() {
            try {
                EORelationshipsTableViewer.this.getEntity().addBlankRelationship(Messages.getString("EORelationship.newName"));
            }
            catch (Throwable e) {
                ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)e);
            }
        }

        protected void doubleSelectionOccurred(ISelection _selection) {
            EORelationship relationship = (EORelationship)((IStructuredSelection)_selection).getFirstElement();
            UserInfoableEOModelObject jumpToModelObject = null;
            EORelationship inverseRelationship = relationship.getInverseRelationship();
            if (inverseRelationship != null) {
                jumpToModelObject = inverseRelationship;
            } else {
                EOEntity destination = relationship.getDestination();
                jumpToModelObject = destination;
            }
            if (jumpToModelObject != null) {
                for (ISelectionChangedListener selectionChangedListener : EORelationshipsTableViewer.this.getSelectionListeners()) {
                    selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)EORelationshipsTableViewer.this.getRelationshipsTableViewer(), (ISelection)new StructuredSelection((Object)jumpToModelObject)));
                }
            }
        }
    }
}

