/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.api;

import java.util.List;
import java.util.Map;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.api.AbstractValidationContainer;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.IValidation;
import org.w3c.dom.Element;

public class Count
extends AbstractValidationContainer {
    protected static final String COUNT = "count";
    public static final String TEST = "test";

    public Count(Element _element, ApiModel _apiModel) {
        super(_element, _apiModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTest() {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            return this.element.getAttribute(TEST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTest(String test) {
        ApiModel apiModel = this.apiModel;
        synchronized (apiModel) {
            this.element.setAttribute(TEST, test);
        }
    }

    @Override
    public boolean evaluate(Map<String, String> bindings) {
        boolean evaluation;
        int count = 0;
        List<IValidation> validationChildren = this.getValidationChildren();
        for (IValidation validation : validationChildren) {
            boolean evaluation2 = validation.evaluate(bindings);
            if (!evaluation2) continue;
            ++count;
        }
        String test = this.getTest();
        if (test == null) {
            evaluation = true;
        } else {
            StringBuffer operatorBuffer = new StringBuffer();
            StringBuffer valueBuffer = new StringBuffer();
            int length = test.length();
            for (int i = 0; i < length; ++i) {
                char ch = test.charAt(i);
                if (ch == '<' || ch == '>' || ch == '=' || ch == '!') {
                    operatorBuffer.append(ch);
                    continue;
                }
                if (ch == ' ' || ch == '\t') continue;
                valueBuffer.append(ch);
            }
            if (valueBuffer.length() > 0) {
                int value = Integer.parseInt(valueBuffer.toString());
                String operator = operatorBuffer.length() == 0 ? "==" : operatorBuffer.toString();
                if ("=".equals(operator) || "==".equals(operator)) {
                    evaluation = value == count;
                } else if (">".equals(operator)) {
                    evaluation = count > value;
                } else if ("<".equals(operator)) {
                    evaluation = count < value;
                } else if (">=".equals(operator) || "=>".equals(operator)) {
                    evaluation = count >= value;
                } else if ("<=".equals(operator) || "=<".equals(operator)) {
                    evaluation = count <= value;
                } else if ("!=".equals(operator)) {
                    evaluation = count != value;
                } else {
                    Activator.getDefault().log("Count.evaluate: Unknown count value " + value);
                    evaluation = true;
                }
            } else {
                evaluation = true;
            }
        }
        return evaluation;
    }
}

