/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.wod;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.api.ApiModelException;
import org.objectstyle.wolips.bindings.api.ApiUtils;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.api.Validation;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.ApiBindingValidationProblem;
import org.objectstyle.wolips.bindings.wod.ApiElementValidationProblem;
import org.objectstyle.wolips.bindings.wod.HtmlElementCache;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.bindings.wod.WodBindingComparator;
import org.objectstyle.wolips.bindings.wod.WodBindingNameProblem;
import org.objectstyle.wolips.bindings.wod.WodElementDeprecationProblem;
import org.objectstyle.wolips.bindings.wod.WodElementProblem;
import org.objectstyle.wolips.bindings.wod.WodProblem;

public abstract class AbstractWodElement
implements IWodElement,
Comparable<IWodElement> {
    private List<IWodBinding> _bindings = new LinkedList<IWodBinding>();
    private boolean _inline;
    private String _tagName;
    private boolean _inherited;

    public void setInherited(boolean inherited) {
        this._inherited = inherited;
    }

    @Override
    public boolean isInherited() {
        return this._inherited;
    }

    @Override
    public boolean isInline() {
        return this._inline;
    }

    public void setInline(boolean inline) {
        this._inline = inline;
    }

    public void addBinding(IWodBinding binding) {
        this._bindings.add(binding);
    }

    public void removeBinding(IWodBinding binding) {
        this._bindings.remove(binding);
    }

    @Override
    public List<IWodBinding> getBindings() {
        return this._bindings;
    }

    @Override
    public IWodBinding getBindingNamed(String name) {
        IWodBinding matchingBinding = null;
        Iterator<IWodBinding> wodBindingsIter = this._bindings.iterator();
        while (matchingBinding == null && wodBindingsIter.hasNext()) {
            IWodBinding wodBinding = wodBindingsIter.next();
            if (!name.equals(wodBinding.getName())) continue;
            matchingBinding = wodBinding;
        }
        return matchingBinding;
    }

    @Override
    public String getBindingValue(String name) {
        String value = null;
        IWodBinding binding = this.getBindingNamed(name);
        if (binding != null) {
            value = binding.getValue();
        }
        return value;
    }

    @Override
    public Map<String, String> getBindingsMap() {
        HashMap<String, String> bindingsMap = new HashMap<String, String>();
        for (IWodBinding binding : this._bindings) {
            bindingsMap.put(binding.getName(), binding.getValue());
        }
        return bindingsMap;
    }

    @Override
    public int compareTo(IWodElement otherElement) {
        String otherName = otherElement.getElementName();
        int comparison = this.getElementName().compareTo(otherName);
        return comparison;
    }

    @Override
    public void writeWodFormat(Writer writer, boolean alphabetize) throws IOException {
        List<IWodBinding> bindings = this.getBindings();
        if (alphabetize) {
            bindings = new LinkedList<IWodBinding>(bindings);
            Collections.sort(bindings, new WodBindingComparator());
        }
        writer.write(this.getElementName());
        writer.write(" : ");
        writer.write(this.getElementType());
        writer.write(" {");
        writer.write("\n");
        for (IWodBinding binding : bindings) {
            binding.writeWodFormat(writer);
            writer.write("\n");
        }
        writer.write("}\n");
    }

    @Override
    public void writeInlineFormat(Writer writer, String content, boolean alphabetize, String bindingPrefix, String bindingSuffix) throws IOException {
        this.writeInlineFormat(writer, content, alphabetize, true, true, true, bindingPrefix, bindingSuffix);
    }

    public void writeInlineFormat(Writer writer, String content, boolean alphabetize, boolean showOpenTag, boolean showContent, boolean showCloseTag, String bindingPrefix, String bindingSuffix) throws IOException {
        List<IWodBinding> bindings = this.getBindings();
        if (alphabetize) {
            bindings = new LinkedList<IWodBinding>(bindings);
            Collections.sort(bindings, new WodBindingComparator());
        }
        if (showOpenTag) {
            writer.write("<");
            writer.write(this.getTagName());
            for (IWodBinding binding : bindings) {
                binding.writeInlineFormat(writer, bindingPrefix, bindingSuffix);
            }
            if (content == null) {
                writer.write("/>");
            } else {
                writer.write(">");
            }
        }
        if (content != null) {
            if (showContent) {
                writer.write(content);
            }
            if (showCloseTag) {
                writer.write("</");
                writer.write(this.getTagName());
                writer.write(">");
            }
        }
    }

    public void setTagName(String tagName) {
        this._tagName = tagName;
    }

    public String getTagName() {
        Object tagName = this._tagName == null ? "wo:" + this.getElementType() : this._tagName;
        return tagName;
    }

    @Override
    public Wo getApi(IJavaProject javaProject, TypeCache cache) throws JavaModelException, ApiModelException {
        String elementTypeName = this.getElementType();
        IType elementType = BindingReflectionUtils.findElementType(javaProject, elementTypeName, false, cache);
        Wo wo = ApiUtils.findApiModelWo(elementType, cache.getApiCache(javaProject));
        return wo;
    }

    @Override
    public IApiBinding[] getApiBindings(Wo api) {
        IApiBinding[] wodBindings = null;
        boolean apiFound = false;
        try {
            if (api != null) {
                apiFound = true;
                LinkedList<IApiBinding> visibleBindings = new LinkedList<IApiBinding>();
                List<Binding> apiBindings = api.getBindings();
                visibleBindings.addAll(apiBindings);
                for (IWodBinding wodBinding : this.getBindings()) {
                    String bindingName = wodBinding.getName();
                    boolean wodBindingDefinedInApi = false;
                    for (IApiBinding iApiBinding : apiBindings) {
                        if (!iApiBinding.getName().equals(bindingName)) continue;
                        wodBindingDefinedInApi = true;
                        break;
                    }
                    if (wodBindingDefinedInApi) continue;
                    visibleBindings.add(wodBinding);
                }
                wodBindings = visibleBindings.toArray(new IApiBinding[visibleBindings.size()]);
            }
        }
        catch (Throwable t) {
            Activator.getDefault().log("Failed to retrieve bindings for " + this + ".", t);
        }
        if (!apiFound) {
            List<IWodBinding> currentBindings = this.getBindings();
            wodBindings = currentBindings.toArray(new IApiBinding[currentBindings.size()]);
        }
        return wodBindings;
    }

    @Override
    public abstract int getLineNumber();

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillInProblems(IJavaProject javaProject, IType javaFileType, boolean checkBindingValues, List<WodProblem> problems, TypeCache typeCache, HtmlElementCache htmlCache) throws CoreException {
        IType elementType;
        String deprecationSeverity;
        String elementTypeName = this.getElementType();
        String elementName = this.getElementName();
        int lineNumber = this.getLineNumber();
        String wodMissingComponentSeverity = Activator.getDefault().getPluginPreferences().getString("WodProblemsSeverityKey");
        String unusedWodElementSeverity = Activator.getDefault().getPluginPreferences().getString("UnusedWodElementSeverityKey");
        if (!("ignore".equals(unusedWodElementSeverity) || this._inline || htmlCache.containsElementNamed(elementName))) {
            problems.add(new WodElementProblem(this, "There is no element named '" + elementName + "' in your component HTML file", this.getElementNamePosition(), lineNumber, "warning".equals(unusedWodElementSeverity)));
        }
        if (!"ignore".equals(deprecationSeverity = Activator.getDefault().getPluginPreferences().getString("DeprecatedBindingSeverityKey")) && BindingReflectionUtils.memberIsDeprecated((IMember)(elementType = BindingReflectionUtils.findElementType(javaProject, elementTypeName, false, typeCache)))) {
            problems.add(new WodElementDeprecationProblem(this, "The component named '" + elementTypeName + "' is deprecated.", this.getElementTypePosition(), lineNumber, "warning".equals(deprecationSeverity)));
        }
        Wo wo = null;
        if (!"ignore".equals(wodMissingComponentSeverity)) {
            IType elementType2 = BindingReflectionUtils.findElementType(javaProject, elementTypeName, false, typeCache);
            if (elementType2 == null || !elementType2.getElementName().equals(elementTypeName) && !elementType2.getFullyQualifiedName().equals(elementTypeName)) {
                problems.add(new WodElementProblem(this, "The class for '" + elementTypeName + "' is either missing or does not extend WOElement.", this.getElementTypePosition(), lineNumber, "warning".equals(wodMissingComponentSeverity)));
            } else {
                String wodApiProblemSeverity = Activator.getDefault().getPluginPreferences().getString("WodApiProblemsSeverityKey");
                if (!"ignore".equals(wodApiProblemSeverity)) {
                    try {
                        wo = ApiUtils.findApiModelWo(elementType2, typeCache.getApiCache(javaProject));
                        if (wo != null) {
                            Map<String, String> bindingsMap = this.getBindingsMap();
                            List<Binding> bindings = wo.getBindings();
                            for (Binding binding : bindings) {
                                String bindingName = binding.getName();
                                if (!binding.isExplicitlyRequired() || bindingsMap.containsKey(bindingName)) continue;
                                problems.add(new ApiBindingValidationProblem(this, binding, this.getElementNamePosition(), lineNumber, "warning".equals(wodApiProblemSeverity)));
                            }
                            List<Validation> failedValidations = wo.getFailedValidations(bindingsMap);
                            for (Validation failedValidation : failedValidations) {
                                problems.add(new ApiElementValidationProblem((IWodElement)this, failedValidation, this.getElementNamePosition(), lineNumber, "warning".equals(wodApiProblemSeverity)));
                            }
                        }
                    }
                    catch (Throwable e) {
                        Activator.getDefault().log(e);
                    }
                }
            }
        }
        HashSet<String> bindingNames = new HashSet<String>();
        for (IWodBinding binding : this.getBindings()) {
            String bindingName = binding.getName();
            if (bindingNames.contains(bindingName)) {
                problems.add(new WodBindingNameProblem(this, binding, bindingName, "Duplicate binding named '" + bindingName + "'", binding.getNamePosition(), binding.getLineNumber(), false));
                continue;
            }
            bindingNames.add(bindingName);
        }
        JavaModelException javaModelException = null;
        if (checkBindingValues && javaFileType != null) {
            for (IWodBinding binding : this.getBindings()) {
                try {
                    void var19_25;
                    Object var19_23 = null;
                    if (wo != null) {
                        Binding binding2 = wo.getBinding(binding.getName());
                    }
                    binding.fillInBindingProblems(this, (IApiBinding)var19_25, javaProject, javaFileType, problems, typeCache, htmlCache);
                }
                catch (JavaModelException javaModelException2) {
                    javaModelException = javaModelException2;
                    Activator.getDefault().log("Failed to check wod binding values.", javaModelException2);
                }
                catch (Throwable throwable) {
                    Activator.getDefault().log("Failed to check wod binding values.", throwable);
                }
            }
        }
        if (javaModelException != null) {
            throw javaModelException;
        }
    }

    @Override
    public boolean isWithin(IRegion region) {
        return this.getStartOffset() <= region.getOffset() && this.getEndOffset() > region.getOffset();
    }

    @Override
    public boolean isTypeWithin(IRegion region) {
        Position typePosition = this.getElementTypePosition();
        return typePosition != null && typePosition.getOffset() <= region.getOffset() && typePosition.getOffset() + typePosition.getLength() > region.getOffset();
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": elementName = " + this.getElementName() + ";  elementType = " + this.getElementType() + "; bindings = " + this._bindings + "]";
    }
}

