/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.wolips.core.resources.builder.IFullBuilder;
import org.objectstyle.wolips.core.resources.builder.IIncrementalBuilder;
import org.objectstyle.wolips.core.resources.types.ILocalizedPath;
import org.objectstyle.wolips.core.resources.types.IPBDotProjectOwner;
import org.objectstyle.wolips.core.resources.types.file.IPBDotProjectAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotEOModeldAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotSubprojAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotWoAdapter;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.preferences.Preferences;

public class PBDotProjectBuilder
implements IIncrementalBuilder,
IFullBuilder {
    private Hashtable affectedPBDotProjectOwner;

    public boolean isEnabled() {
        return Preferences.shouldWritePBProjOnBuild();
    }

    private String key(IResource resource) {
        return resource.getLocation().toPortableString();
    }

    private IPBDotProjectAdapter getIPBDotProjectAdapterForKey(IResource resource) {
        String key = this.key(resource);
        if (this.affectedPBDotProjectOwner.containsKey(key)) {
            return (IPBDotProjectAdapter)this.affectedPBDotProjectOwner.get(key);
        }
        return null;
    }

    private void setIPBDotProjectOwnerForKey(IPBDotProjectAdapter pbDotProjectAdapter, IResource resource) {
        this.affectedPBDotProjectOwner.put(this.key(resource), pbDotProjectAdapter);
    }

    public boolean buildStarted(int kind, Map args, IProgressMonitor monitor, IProject project, Map buildCache) {
        this.affectedPBDotProjectOwner = new Hashtable();
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        IPBDotProjectAdapter adapter = projectAdapter.getPBDotProjectAdapter();
        boolean fullBuildRequested = adapter.isRebuildRequired();
        return fullBuildRequested;
    }

    public boolean buildPreparationDone(int kind, Map args, IProgressMonitor monitor, IProject project, Map buildCache) {
        for (Object object : this.affectedPBDotProjectOwner.values()) {
            IPBDotProjectAdapter pbDotProjectAdapter = (IPBDotProjectAdapter)object;
            pbDotProjectAdapter.save();
        }
        this.affectedPBDotProjectOwner = null;
        return false;
    }

    private IPBDotProjectOwner getIPBDotProjectOwner(IResource resource) {
        IProject project = resource.getProject();
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        IPBDotProjectOwner pbDotProjectOwner = projectAdapter.getPBDotProjectOwner(resource);
        return pbDotProjectOwner;
    }

    public IPBDotProjectAdapter getIPBDotProjectAdapter(IPBDotProjectOwner pbDotProjectOwner) {
        IPBDotProjectAdapter pbDotProjectAdapter = this.getIPBDotProjectAdapterForKey(pbDotProjectOwner.getUnderlyingResource());
        if (pbDotProjectAdapter == null) {
            pbDotProjectAdapter = pbDotProjectOwner.getPBDotProjectAdapter();
            this.setIPBDotProjectOwnerForKey(pbDotProjectAdapter, pbDotProjectOwner.getUnderlyingResource());
        }
        return pbDotProjectAdapter;
    }

    public void handleSourceDelta(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
        IResource resource = delta.getResource();
        this.handleSource(delta.getKind(), resource);
    }

    public void handleSource(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
        this.handleSource(1, resource);
    }

    private boolean handleSource(int kind, IResource resource) {
        if (kind == 1 || kind == 4 || kind == 2) {
            IPBDotProjectOwner pbDotProjectOwner = this.getIPBDotProjectOwner(resource);
            IPBDotProjectAdapter pbDotProjectAdapter = this.getIPBDotProjectAdapter(pbDotProjectOwner);
            ILocalizedPath localizedPath = pbDotProjectAdapter.localizedRelativeResourcePath(pbDotProjectOwner, resource);
            if (kind == 1 || kind == 4) {
                pbDotProjectAdapter.addClass(localizedPath);
            } else if (kind == 2) {
                pbDotProjectAdapter.removeClass(localizedPath);
            }
        }
        return false;
    }

    public void handleClassesDelta(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
    }

    public void handleClasses(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
    }

    public void handleWoappResourcesDelta(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
        this.handleWoappResources(delta.getKind(), delta.getResource());
    }

    public void handleWoappResources(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
        this.handleWoappResources(1, resource);
    }

    public void handleWoappResources(int kind, IResource resource) {
        if (kind == 1 || kind == 4 || kind == 2) {
            boolean parentIsDotEOModeld;
            boolean parentIsDotWO;
            IPBDotProjectOwner pbDotProjectOwner = this.getIPBDotProjectOwner(resource);
            IPBDotProjectAdapter pbDotProjectAdapter = this.getIPBDotProjectAdapter(pbDotProjectOwner);
            ILocalizedPath localizedPath = pbDotProjectAdapter.localizedRelativeResourcePath(pbDotProjectOwner, resource);
            IDotWoAdapter dotWoAdapter = (IDotWoAdapter)resource.getAdapter(IDotWoAdapter.class);
            boolean isDotWO = dotWoAdapter != null;
            IDotWoAdapter parentWoAdapter = null;
            if (resource.getParent() != null) {
                parentWoAdapter = (IDotWoAdapter)resource.getParent().getAdapter(IDotWoAdapter.class);
            }
            boolean bl = parentIsDotWO = parentWoAdapter != null;
            if (parentIsDotWO) {
                return;
            }
            IDotEOModeldAdapter parentDotEOModeldAdapter = null;
            if (resource.getParent() != null) {
                parentDotEOModeldAdapter = (IDotEOModeldAdapter)resource.getParent().getAdapter(IDotEOModeldAdapter.class);
            }
            boolean bl2 = parentIsDotEOModeld = parentDotEOModeldAdapter != null;
            if (parentIsDotEOModeld) {
                return;
            }
            if (kind == 1 || kind == 4) {
                if (isDotWO) {
                    pbDotProjectAdapter.addWoComponent(localizedPath);
                } else {
                    pbDotProjectAdapter.addWoappResource(localizedPath);
                }
            } else if (kind == 2) {
                if (isDotWO) {
                    pbDotProjectAdapter.removeWoComponent(localizedPath);
                } else {
                    pbDotProjectAdapter.removeWoappResource(localizedPath);
                }
            }
        }
    }

    public void handleWebServerResources(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
        this.handleWebServerResources(1, resource);
    }

    public void handleWebServerResourcesDelta(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
        IResource resource = delta.getResource();
        this.handleWebServerResources(delta.getKind(), resource);
    }

    private void handleWebServerResources(int kind, IResource resource) {
        if (kind == 1 || kind == 4 || kind == 2) {
            IPBDotProjectOwner pbDotProjectOwner = this.getIPBDotProjectOwner(resource);
            IPBDotProjectAdapter pbDotProjectAdapter = this.getIPBDotProjectAdapter(pbDotProjectOwner);
            ILocalizedPath localizedPath = pbDotProjectAdapter.localizedRelativeResourcePath(pbDotProjectOwner, resource);
            if (kind == 1 || kind == 4) {
                pbDotProjectAdapter.addWebServerResource(localizedPath);
            } else if (kind == 2) {
                pbDotProjectAdapter.removeWebServerResource(localizedPath);
            }
        }
    }

    public void handleOther(IResource resource, IProgressMonitor monitor, Map buildCache) {
        this.handleOther(1, resource);
    }

    public void handleOtherDelta(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
        IResource resource = delta.getResource();
        this.handleOther(delta.getKind(), resource);
    }

    private void handleOther(int kind, IResource resource) {
        IDotSubprojAdapter dotSubprojAdapter = (IDotSubprojAdapter)resource.getAdapter(IDotSubprojAdapter.class);
        if (dotSubprojAdapter == null) {
            return;
        }
        IPBDotProjectOwner pbDotProjectOwner = this.getIPBDotProjectOwner((IResource)resource.getParent());
        IPBDotProjectAdapter pbDotProjectAdapter = this.getIPBDotProjectAdapter(pbDotProjectOwner);
        if (kind == 1) {
            pbDotProjectAdapter.addSubproject(dotSubprojAdapter);
        }
        if (kind == 2) {
            pbDotProjectAdapter.removeSubproject(dotSubprojAdapter);
        }
    }

    public void handleClasspath(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
        IPBDotProjectOwner pbDotProjectOwner = this.getIPBDotProjectOwner(resource);
        IPBDotProjectAdapter pbDotProjectAdapter = this.getIPBDotProjectAdapter(pbDotProjectOwner);
        IProject project = resource.getProject();
        ProjectFrameworkAdapter projectAdapter = (ProjectFrameworkAdapter)project.getAdapter(ProjectFrameworkAdapter.class);
        try {
            Set frameworkNames = projectAdapter.getLinkedFrameworkNames();
            pbDotProjectAdapter.updateFrameworkNames(new LinkedList(frameworkNames));
        }
        catch (JavaModelException e) {
            throw new RuntimeException("Unable to retrieve a list of frameworks.", e);
        }
    }

    public void classpathChanged(IResourceDelta delta, IProgressMonitor monitor, Map buildCache) {
        IResource resource = delta.getResource();
        this.handleClasspath(resource, monitor, buildCache);
    }
}

