/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.ui.labeldecorator;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.objectstyle.wolips.core.resources.types.project.IProjectPatternsets;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.ui.UIPlugin;

public class ResourcesLabelDecorator
implements ILabelDecorator {
    protected static Map<String, Map<Image, WOImageDescriptor>> _imageDescriptors;

    private Image createImageWithName(Image image, String aString) {
        return UIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)ResourcesLabelDecorator.cachedImageDescriptor(image, aString));
    }

    private Image resourcesImage(Image image) {
        return this.createImageWithName(image, "resources_overlay.gif");
    }

    private Image webServerResourcesImage(Image image) {
        return this.createImageWithName(image, "webserverresources_overlay.gif");
    }

    public Image decorateImage(Image image, Object element) {
        IProjectPatternsets projectPatternsets;
        IResource resource;
        IProject project;
        ProjectAdapter projectAdapter;
        if (element instanceof IResource && !(element instanceof IProject) && (projectAdapter = (ProjectAdapter)(project = (resource = (IResource)element).getProject()).getAdapter(ProjectAdapter.class)) != null && (projectPatternsets = (IProjectPatternsets)project.getAdapter(IProjectPatternsets.class)) != null) {
            if (projectPatternsets.matchesResourcesPattern(resource)) {
                return this.resourcesImage(image);
            }
            if (projectPatternsets.matchesWOAppResourcesPattern(resource)) {
                return this.webServerResourcesImage(image);
            }
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static WOImageDescriptor cachedImageDescriptor(Image image, String overlayImageFilename) {
        WOImageDescriptor imageDescriptor;
        Map<Image, WOImageDescriptor> overlayImageDescriptors;
        if (_imageDescriptors == null) {
            _imageDescriptors = new HashMap<String, Map<Image, WOImageDescriptor>>();
        }
        if ((overlayImageDescriptors = _imageDescriptors.get(overlayImageFilename)) == null) {
            overlayImageDescriptors = new WeakHashMap<Image, WOImageDescriptor>();
            _imageDescriptors.put(overlayImageFilename, overlayImageDescriptors);
        }
        if ((imageDescriptor = overlayImageDescriptors.get(image)) == null) {
            imageDescriptor = new WOImageDescriptor(image, overlayImageFilename);
            overlayImageDescriptors.put(image, imageDescriptor);
        }
        return imageDescriptor;
    }

    private static class WOImageDescriptor
    extends CompositeImageDescriptor {
        private Image baseImage;
        private String overlayImageFilename;
        private ImageData baseImageData;
        private ImageData overlayImageData;
        private Point size;

        public WOImageDescriptor(Image image, String overlayImageFilename) {
            if (image != null) {
                this.baseImage = image;
                this.baseImageData = image.getImageData();
                this.size = new Point(this.baseImageData.width, this.baseImageData.height);
            }
            this.overlayImageFilename = overlayImageFilename;
            this.overlayImageData = ImageDescriptor.createFromFile(ResourcesLabelDecorator.class, (String)overlayImageFilename).getImageData();
            if (this.size == null) {
                this.size = new Point(this.overlayImageData.width, this.overlayImageData.height);
            }
        }

        protected void drawCompositeImage(int width, int height) {
            if (this.baseImageData != null) {
                this.drawImage(this.baseImageData, 0, 0);
            }
            int x = this.getSize().x;
            int y = this.getSize().y;
            y -= this.overlayImageData.height;
            this.drawImage(this.overlayImageData, x -= this.overlayImageData.width, 0);
        }

        protected Point getSize() {
            return this.size;
        }

        public boolean equals(Object object) {
            if (object == null || !WOImageDescriptor.class.equals(object.getClass())) {
                return false;
            }
            WOImageDescriptor other = (WOImageDescriptor)((Object)object);
            boolean equals = true;
            equals = this.baseImage == null ? other.baseImage == null : this.baseImage.equals((Object)other.baseImage);
            if (equals) {
                equals = this.overlayImageFilename.equals(other.overlayImageFilename);
            }
            return equals;
        }

        public int hashCode() {
            int hashcode = 0;
            if (this.baseImage != null) {
                hashcode |= this.baseImage.hashCode();
            }
            return hashcode |= this.overlayImageFilename.hashCode();
        }
    }
}

