/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.editors.patterset;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.objectstyle.wolips.baseforplugins.util.ArrayUtilities;
import org.objectstyle.wolips.editors.patterset.PatternsetEditor;
import org.objectstyle.wolips.editors.patterset.PatternsetEditorMessages;

public class PatternsetPage
extends FormPage {
    private ArrayList patternList;
    private Table table;
    private Button changeButton;
    private Button removeButton;

    public PatternsetPage(PatternsetEditor editor, ArrayList patternList) {
        super((FormEditor)editor, "Pattern", "Pattern");
        this.patternList = patternList;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText("Pattern");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        form.getBody().setLayout((Layout)layout);
        this.createTableSection(form, toolkit, "Pattern");
    }

    private void createTableSection(final ScrolledForm form, FormToolkit toolkit, String title) {
        Section section = toolkit.createSection(form.getBody(), 130);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        toolkit.createCompositeSeparator((Composite)section);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.table = toolkit.createTable(client, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 100;
        this.table.setLayoutData((Object)gd);
        for (int i = 0; i < this.patternList.size(); ++i) {
            TableItem item = new TableItem(this.table, 0);
            item.setText((String)this.patternList.get(i));
        }
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PatternsetPage.this.handleSelection();
            }
        });
        toolkit.paintBordersFor(client);
        Composite row = new Composite(client, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        row.setLayout((Layout)rowLayout);
        Button b = toolkit.createButton(row, PatternsetEditorMessages.getString("PaternsetEditor.add"), 8);
        b.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PatternsetPage.this.addPattern();
            }
        });
        this.removeButton = toolkit.createButton(row, PatternsetEditorMessages.getString("PaternsetEditor.remove"), 8);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PatternsetPage.this.removePattern();
            }
        });
        this.changeButton = toolkit.createButton(row, PatternsetEditorMessages.getString("PaternsetEditor.change"), 8);
        this.changeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PatternsetPage.this.changePattern();
            }
        });
        section.setText(title);
        section.setDescription("");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        this.changeButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    void addPattern() {
        InputDialog patternDialog = new InputDialog(this.getEditorSite().getShell(), PatternsetEditorMessages.getString("PaternsetEditor.enterPatternShort"), PatternsetEditorMessages.getString("PaternsetEditor.enterPatternLong"), null, null);
        patternDialog.open();
        if (patternDialog.getReturnCode() != 0) {
            return;
        }
        String pattern = patternDialog.getValue();
        if (pattern.equals("")) {
            return;
        }
        TableItem[] items = this.table.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getText().equals(pattern)) continue;
            MessageDialog.openWarning((Shell)this.getEditorSite().getShell(), (String)PatternsetEditorMessages.getString("PaternsetEditor.patternExistsShort"), (String)PatternsetEditorMessages.getString("PaternsetEditor.patternExistsLong"));
            return;
        }
        TableItem item = new TableItem(this.table, 0);
        item.setText(pattern);
        this.patternList.add(pattern);
        this.markDirty();
    }

    void removePattern() {
        int[] selection = this.table.getSelectionIndices();
        this.table.remove(selection);
        if (selection == null) {
            return;
        }
        int[] newIndices = new int[selection.length];
        System.arraycopy(selection, 0, newIndices, 0, selection.length);
        ArrayUtilities.sort((int[])selection);
        int last = -1;
        for (int i = 0; i < newIndices.length; ++i) {
            int index = newIndices[i];
            if (index != last || i == 0) {
                this.patternList.remove(index);
            }
            last = index;
        }
        this.markDirty();
    }

    void changePattern() {
        int[] selection = this.table.getSelectionIndices();
        if (selection.length != 1) {
            return;
        }
        int index = selection[0];
        InputDialog patternDialog = new InputDialog(this.getEditorSite().getShell(), PatternsetEditorMessages.getString("PaternsetEditor.enterPatternShort"), PatternsetEditorMessages.getString("PaternsetEditor.enterPatternLong"), (String)this.patternList.get(index), null);
        patternDialog.open();
        if (patternDialog.getReturnCode() != 0) {
            return;
        }
        String pattern = patternDialog.getValue();
        TableItem item = this.table.getItem(index);
        item.setText(pattern);
        this.patternList.set(index, pattern);
        this.markDirty();
    }

    void handleSelection() {
        if (this.table.getSelectionCount() > 0) {
            this.changeButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.changeButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void markDirty() {
        ((PatternsetEditor)this.getEditor()).setDirty(true);
    }
}

