/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.userInfo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.baseforuiplugins.plist.IPropertyListChangeListener;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListEditor;
import org.objectstyle.wolips.eomodeler.core.model.IUserInfoable;
import org.objectstyle.wolips.eomodeler.core.utils.NotificationMap;

public class UserInfoPropertySection
extends AbstractPropertySection
implements IPropertyListChangeListener,
PropertyChangeListener {
    private IUserInfoable _userInfoable;
    private PropertyListEditor _propertyListEditor;

    public void createControls(Composite _parent, TabbedPropertySheetPage _tabbedPropertySheetPage) {
        super.createControls(_parent, _tabbedPropertySheetPage);
        HashSet<String> filteredKeyPaths = new HashSet<String>();
        filteredKeyPaths.add("Root._EntityModeler");
        this._propertyListEditor = new PropertyListEditor(_parent, true, false, filteredKeyPaths);
        this._propertyListEditor.setListener((IPropertyListChangeListener)this);
    }

    public void setInput(IWorkbenchPart _part, ISelection _selection) {
        NotificationMap<Object, Object> userInfo;
        super.setInput(_part, _selection);
        this.removeListeners();
        if (_selection instanceof IStructuredSelection) {
            this._userInfoable = (IUserInfoable)((IStructuredSelection)_selection).getFirstElement();
            userInfo = this._userInfoable.getUserInfo();
            if (userInfo == null) {
                userInfo = new NotificationMap();
                this._userInfoable.setUserInfo(userInfo);
            }
            userInfo.addPropertyChangeListener(this);
        } else {
            this._userInfoable = null;
            userInfo = null;
        }
        this._propertyListEditor.setInput(userInfo);
        this.refresh();
    }

    protected void removeListeners() {
        if (this._userInfoable != null) {
            this._userInfoable.getUserInfo().removePropertyChangeListener(this);
        }
    }

    public void dispose() {
        super.dispose();
        this.removeListeners();
    }

    public void refresh() {
        super.refresh();
        this._propertyListEditor.refresh();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public IUserInfoable getUserInfoable() {
        return this._userInfoable;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this._propertyListEditor.refresh();
    }

    public void pathRenamed(String oldPath, String newPath) {
        this.updateUserInfo();
    }

    public void pathAdded(String path, Object value) {
        this.updateUserInfo();
    }

    public void pathRemoved(String path, Object value) {
        this.updateUserInfo();
    }

    public void pathChanged(String path, Object oldValue, Object newValue) {
        this.updateUserInfo();
    }

    protected void updateUserInfo() {
        Map userInfo = (Map)this._propertyListEditor.getInput();
        this._userInfoable.setUserInfo(userInfo);
    }
}

