/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wooeditor.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.objectstyle.wolips.wodclipse.core.woo.DisplayGroup;
import org.objectstyle.wolips.wooeditor.databinding.observable.CustomSWTObservables;
import org.objectstyle.wolips.wooeditor.widgets.RadioGroup;

public class DisplayGroupDetailsPage
implements IDetailsPage {
    private IManagedForm myManagedForm;
    private DisplayGroup myDisplayGroup;
    private Group myMasterDetailGroup;
    private Text myNameText;
    private Combo myClassNameCombo;
    private Spinner myEntriesPerBatchSpinner;
    private Combo myEntityCombo;
    private Text myEditingContextText;
    private Combo myMasterEntityCombo;
    private Combo mySortAttributeCombo;
    private Combo myFetchSpecCombo;
    private Combo myDetailKeyCombo;
    private Combo myQualificationCombo;
    private Button myHasDetailButton;
    private Button myFetchOnLoadButton;
    private Button mySelectsFirstObjectButton;
    private RadioGroup mySortRadioGroup;
    private DataBindingContext myBindingContext;
    private PropertyChangeListener myDirtyStateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DisplayGroupDetailsPage.this.myManagedForm.dirtyStateChanged();
        }
    };
    private final ModifyListener myEntityModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Object selection = DisplayGroupDetailsPage.this.mySortRadioGroup.getSelection();
            if (!"Not Sorted".equals(selection)) {
                DisplayGroupDetailsPage.this.mySortRadioGroup.setSelection("Not Sorted");
            }
            if (!DisplayGroupDetailsPage.this.myHasDetailButton.getSelection()) {
                DisplayGroupDetailsPage.this.myDetailKeyCombo.setText("");
            }
        }
    };
    private final ModifyListener myMasterEntityListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            DisplayGroupDetailsPage.this.myDetailKeyCombo.setText("");
        }
    };
    private final SelectionListener mySortEntityListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            Object selection = DisplayGroupDetailsPage.this.mySortRadioGroup.getSelection();
            if ("Not Sorted".equals(selection)) {
                DisplayGroupDetailsPage.this.mySortRadioGroup.setSelection("Ascending");
            }
        }
    };

    private void bind() {
        if (this.myDisplayGroup == null) {
            return;
        }
        this.myBindingContext = new DataBindingContext();
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.myNameText), BeanProperties.value((String)"name").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindList((IObservableList)WidgetProperties.items().observe((Widget)this.myClassNameCombo), BeanProperties.list((String)"classNameList").observe(Realm.getDefault(), (Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.singleSelectionIndex().observe((Widget)this.myClassNameCombo), BeanProperties.value((String)"classNameIndex").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindList((IObservableList)WidgetProperties.items().observe((Widget)this.myEntityCombo), BeanProperties.list((String)"entityList").observe(Realm.getDefault(), (Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.myMasterDetailGroup), BeanProperties.value((String)"hasMasterDetail").observe((Object)this.myDisplayGroup), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        UpdateValueStrategy<Object, Boolean> booleanInverse = new UpdateValueStrategy<Object, Boolean>(UpdateValueStrategy.POLICY_UPDATE){

            protected IStatus doSet(IObservableValue<? super Boolean> observableValue, Boolean value) {
                Boolean newValue = value == false;
                return super.doSet(observableValue, (Object)newValue);
            }
        };
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.myEntityCombo), BeanProperties.value((String)"hasMasterDetail").observe((Object)this.myDisplayGroup), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)booleanInverse);
        this.myBindingContext.bindValue((IObservableValue)CustomSWTObservables.observeText((Control)this.myEntityCombo), BeanProperties.value((String)"entityName").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.myEditingContextText), BeanProperties.value((String)"hasMasterDetail").observe((Object)this.myDisplayGroup), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)booleanInverse);
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.myEditingContextText), BeanProperties.value((String)"editingContext").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.myHasDetailButton), BeanProperties.value((String)"hasMasterDetail").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindList((IObservableList)WidgetProperties.items().observe((Widget)this.myMasterEntityCombo), BeanProperties.list((String)"entityList").observe(Realm.getDefault(), (Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)CustomSWTObservables.observeText((Control)this.myMasterEntityCombo), BeanProperties.value((String)"masterEntityName").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindList((IObservableList)WidgetProperties.items().observe((Widget)this.myDetailKeyCombo), BeanProperties.list((String)"detailKeyList").observe(Realm.getDefault(), (Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)CustomSWTObservables.observeText((Control)this.myDetailKeyCombo), BeanProperties.value((String)"detailKeyName").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.spinnerSelection().observe((Widget)this.myEntriesPerBatchSpinner), BeanProperties.value((String)"entriesPerBatch").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.mySelectsFirstObjectButton), BeanProperties.value((String)"selectsFirstObject").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindList((IObservableList)WidgetProperties.items().observe((Widget)this.myQualificationCombo), BeanProperties.list((String)"qualificationList").observe(Realm.getDefault(), (Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.singleSelectionIndex().observe((Widget)this.myQualificationCombo), BeanProperties.value((String)"qualificationIndex").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.myFetchOnLoadButton), BeanProperties.value((String)"fetchesOnLoad").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindList((IObservableList)WidgetProperties.items().observe((Widget)this.mySortAttributeCombo), BeanProperties.list((String)"sortList").observe(Realm.getDefault(), (Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue((IObservableValue)CustomSWTObservables.observeSelection((Control)this.mySortAttributeCombo), BeanProperties.value((String)"sortOrderKey").observe((Object)this.myDisplayGroup), null, null);
        this.myBindingContext.bindValue(CustomSWTObservables.observeSelection(this.mySortRadioGroup), BeanProperties.value((String)"sortOrder").observe((Object)this.myDisplayGroup), null, null);
        UpdateValueStrategy fetchSpecEmpty = new UpdateValueStrategy();
        fetchSpecEmpty.setConverter((IConverter)new IConverter<Object, Boolean>(){

            public Boolean convert(Object fromObject) {
                boolean result;
                boolean bl = result = fromObject != null && ((List)fromObject).size() > 0;
                if (!DisplayGroupDetailsPage.this.myHasDetailButton.getSelection()) {
                    return result;
                }
                return false;
            }

            public Object getFromType() {
                return new ArrayList();
            }

            public Object getToType() {
                return true;
            }
        });
        UpdateValueStrategy<Object, Boolean> fetchSpecEnabled = new UpdateValueStrategy<Object, Boolean>(UpdateValueStrategy.POLICY_UPDATE){

            protected IStatus doSet(IObservableValue<? super Boolean> observableValue, Boolean value) {
                Boolean newValue = false;
                if (DisplayGroupDetailsPage.this.myFetchSpecCombo.getItemCount() > 0) {
                    newValue = value == false;
                }
                return super.doSet(observableValue, (Object)newValue);
            }
        };
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.myFetchSpecCombo), BeanProperties.value((String)"hasMasterDetail").observe((Object)this.myDisplayGroup), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), (UpdateValueStrategy)fetchSpecEnabled);
        this.myBindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.myFetchSpecCombo), BeanProperties.value(DisplayGroup.class, (String)"fetchSpecList").observe((Object)this.myDisplayGroup), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), fetchSpecEmpty);
        this.myBindingContext.bindList((IObservableList)WidgetProperties.items().observe((Widget)this.myFetchSpecCombo), BeanProperties.list((String)"fetchSpecList").observe(Realm.getDefault(), (Object)this.myDisplayGroup), null, null);
        UpdateValueStrategy<Object, String> fetchSpecSelection = new UpdateValueStrategy<Object, String>(){

            protected IStatus doSet(IObservableValue<? super String> observableValue, String value) {
                if (value == null || value.equals("")) {
                    value = "<None>";
                }
                return super.doSet(observableValue, (Object)value);
            }
        };
        this.myBindingContext.bindValue((IObservableValue)CustomSWTObservables.observeSelection((Control)this.myFetchSpecCombo), BeanProperties.value((String)"fetchSpecName").observe((Object)this.myDisplayGroup), null, (UpdateValueStrategy)fetchSpecSelection);
        this.myEntityCombo.addModifyListener(this.myEntityModifyListener);
        this.myMasterEntityCombo.addModifyListener(this.myMasterEntityListener);
        this.mySortAttributeCombo.addSelectionListener(this.mySortEntityListener);
    }

    public void commit(boolean onSave) {
    }

    public void createContents(Composite parent) {
        TableWrapLayout pageLayout = new TableWrapLayout();
        pageLayout.topMargin = 5;
        pageLayout.leftMargin = 5;
        pageLayout.rightMargin = 2;
        pageLayout.bottomMargin = 2;
        parent.setLayout((Layout)pageLayout);
        FormToolkit form = this.myManagedForm.getToolkit();
        Section displayGroupSection = form.createSection(parent, 256);
        displayGroupSection.marginWidth = 10;
        displayGroupSection.setText("Display Group Details");
        displayGroupSection.setDescription("Set the properties of the selected display group.");
        TableWrapData tableWrapData = new TableWrapData(128, 16);
        tableWrapData.grabHorizontal = true;
        displayGroupSection.setLayoutData((Object)tableWrapData);
        Composite displayGroupComposite = form.createComposite((Composite)displayGroupSection);
        GridLayout displayGroupLayout = new GridLayout();
        displayGroupLayout.marginWidth = 0;
        displayGroupLayout.marginHeight = 0;
        displayGroupLayout.numColumns = 2;
        displayGroupComposite.setLayout((Layout)displayGroupLayout);
        form.createLabel(displayGroupComposite, "Name:");
        this.myNameText = form.createText(displayGroupComposite, "", 4);
        GridData nameFieldLayoutData = new GridData(4, 4, true, false);
        this.myNameText.setLayoutData((Object)nameFieldLayoutData);
        form.createLabel(displayGroupComposite, "Class Type:");
        this.myClassNameCombo = new Combo(displayGroupComposite, 8);
        GridData classNameFieldLayoutData = new GridData(4, 4, true, false);
        this.myNameText.setLayoutData((Object)classNameFieldLayoutData);
        form.createLabel(displayGroupComposite, "Entity:");
        this.myEntityCombo = new Combo(displayGroupComposite, 4);
        GridData entityFieldLayoutData = new GridData(4, 4, true, false);
        this.myEntityCombo.setLayoutData((Object)entityFieldLayoutData);
        form.createLabel(displayGroupComposite, "Editing Context:");
        this.myEditingContextText = form.createText(displayGroupComposite, "", 4);
        GridData editingContextFieldLayoutData = new GridData(4, 4, true, false);
        this.myEditingContextText.setLayoutData((Object)editingContextFieldLayoutData);
        this.createSpacer(form, displayGroupComposite, 1);
        this.myHasDetailButton = form.createButton(displayGroupComposite, "Has detail data source", 32);
        GridData hasDetailLayoutData = new GridData(4, 4, true, false);
        hasDetailLayoutData.horizontalIndent = 5;
        this.myHasDetailButton.setLayoutData((Object)hasDetailLayoutData);
        this.myMasterDetailGroup = new Group(displayGroupComposite, 0);
        this.myMasterDetailGroup.setBackground(displayGroupComposite.getBackground());
        this.myMasterDetailGroup.setText("Master / Detail");
        GridLayout masterDetailLayout = new GridLayout();
        masterDetailLayout.numColumns = 2;
        this.myMasterDetailGroup.setEnabled(false);
        this.myMasterDetailGroup.setLayout((Layout)masterDetailLayout);
        GridData masterDetailLayoutData = new GridData(4, 4, true, false);
        masterDetailLayoutData.horizontalSpan = 2;
        this.myMasterDetailGroup.setLayoutData((Object)masterDetailLayoutData);
        form.createLabel((Composite)this.myMasterDetailGroup, "Master Entity:");
        this.myMasterEntityCombo = new Combo((Composite)this.myMasterDetailGroup, 4);
        GridData masterEntityFieldLayoutData = new GridData(4, 4, true, false);
        this.myMasterEntityCombo.setLayoutData((Object)masterEntityFieldLayoutData);
        this.myMasterEntityCombo.setData((Object)"myMasterEntityCombo");
        Label label = form.createLabel((Composite)this.myMasterDetailGroup, "Detail Key:");
        label.setAlignment(131072);
        this.myDetailKeyCombo = new Combo((Composite)this.myMasterDetailGroup, 4);
        GridData detailKeyFieldLayoutData = new GridData(4, 4, true, false);
        this.myDetailKeyCombo.setLayoutData((Object)detailKeyFieldLayoutData);
        Composite batchGroupComposite = new Composite(displayGroupComposite, 0);
        batchGroupComposite.setBackground(displayGroupComposite.getBackground());
        GridLayout batchLayout = new GridLayout();
        batchLayout.numColumns = 2;
        batchGroupComposite.setLayout((Layout)batchLayout);
        GridData batchGroupLayoutData = new GridData(4, 4, true, false);
        batchGroupLayoutData.horizontalSpan = 2;
        batchGroupComposite.setLayoutData((Object)batchGroupLayoutData);
        form.createLabel(batchGroupComposite, "Entities per batch:");
        this.myEntriesPerBatchSpinner = new Spinner(batchGroupComposite, 0);
        this.myEntriesPerBatchSpinner.setIncrement(5);
        GridData entriesPerBatchLayoutData = new GridData(4, 4, false, false);
        this.myEntriesPerBatchSpinner.setLayoutData((Object)entriesPerBatchLayoutData);
        this.createSpacer(form, displayGroupComposite, 1);
        this.mySelectsFirstObjectButton = form.createButton(displayGroupComposite, "Selects first object on load", 32);
        GridData selectsFirstObjectLayoutData = new GridData(4, 4, true, false);
        selectsFirstObjectLayoutData.horizontalIndent = 5;
        this.mySelectsFirstObjectButton.setLayoutData((Object)selectsFirstObjectLayoutData);
        this.createSpacer(form, displayGroupComposite, 1);
        this.myFetchOnLoadButton = form.createButton(displayGroupComposite, "Fetches on load", 32);
        GridData fetchOnLoadLayoutData = new GridData(4, 4, true, false);
        fetchOnLoadLayoutData.horizontalIndent = 5;
        this.myFetchOnLoadButton.setLayoutData((Object)fetchOnLoadLayoutData);
        form.createLabel(displayGroupComposite, "Qualification:");
        this.myQualificationCombo = new Combo(displayGroupComposite, 8);
        GridData qualificationFieldLayoutData = new GridData(4, 4, true, false);
        this.myQualificationCombo.setLayoutData((Object)qualificationFieldLayoutData);
        form.createLabel(displayGroupComposite, "Sorting:");
        this.mySortAttributeCombo = new Combo(displayGroupComposite, 8);
        GridData sortingFieldLayoutData = new GridData(4, 4, true, false);
        this.mySortAttributeCombo.setLayoutData((Object)sortingFieldLayoutData);
        this.createSpacer(form, displayGroupComposite, 1);
        Composite radioGroupComposite = new Composite(displayGroupComposite, 262144);
        radioGroupComposite.setLayout((Layout)new GridLayout());
        this.mySortRadioGroup = new RadioGroup();
        for (String s : DisplayGroup.SORT_OPTIONS) {
            Button sortButton = form.createButton(radioGroupComposite, s, 16);
            GridData sortButtonLayoutData = new GridData(4, 4, true, false);
            sortButton.setLayoutData((Object)sortButtonLayoutData);
            this.mySortRadioGroup.add(sortButton);
        }
        form.createLabel(displayGroupComposite, "Fetch Spec:");
        this.myFetchSpecCombo = new Combo(displayGroupComposite, 8);
        GridData fetchSpecFieldLayoutData = new GridData(4, 4, true, false);
        this.myFetchSpecCombo.setLayoutData((Object)fetchSpecFieldLayoutData);
        form.paintBordersFor((Composite)displayGroupSection);
        displayGroupSection.setClient((Control)displayGroupComposite);
    }

    private void createSpacer(FormToolkit toolkit, Composite parent, int span) {
        Label spacer = toolkit.createLabel(parent, "");
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        spacer.setLayoutData((Object)gd);
    }

    public void dispose() {
        this.disposeBindings();
    }

    protected void disposeBindings() {
        if (this.myBindingContext != null) {
            this.myBindingContext.dispose();
        }
        if (this.myEntityCombo != null && !this.myEntityCombo.isDisposed()) {
            this.myEntityCombo.removeModifyListener(this.myEntityModifyListener);
        }
        if (this.myMasterEntityCombo != null && !this.myMasterEntityCombo.isDisposed()) {
            this.myMasterEntityCombo.removeModifyListener(this.myMasterEntityListener);
        }
        if (this.mySortAttributeCombo != null && !this.mySortAttributeCombo.isDisposed()) {
            this.mySortAttributeCombo.removeSelectionListener(this.mySortEntityListener);
        }
    }

    public void initialize(IManagedForm form) {
        this.myManagedForm = form;
    }

    public boolean isDirty() {
        if (this.myDisplayGroup == null) {
            return false;
        }
        return this.myDisplayGroup.getWooModel().isDirty();
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        this.disposeBindings();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() > 0) {
            this.setDisplayGroup((DisplayGroup)ssel.getFirstElement());
        } else {
            this.setDisplayGroup(null);
        }
        this.bind();
    }

    public void setDisplayGroup(DisplayGroup displayGroup) {
        if (this.myDisplayGroup != null) {
            this.myDisplayGroup.removePropertyChangeListener(this.myDirtyStateListener);
        }
        this.myDisplayGroup = displayGroup;
        if (this.myDisplayGroup != null) {
            this.myDisplayGroup.addPropertyChangeListener(this.myDirtyStateListener);
        }
    }

    public void setFocus() {
        this.myNameText.setFocus();
    }

    public boolean setFormInput(Object input) {
        return false;
    }
}

