/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wooeditor.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.baseforplugins.util.CharSetUtils;
import org.objectstyle.wolips.wodclipse.core.woo.WooModel;
import org.objectstyle.wolips.wooeditor.WooeditorPlugin;
import org.objectstyle.wolips.wooeditor.editor.DisplayGroupPage;
import org.objectstyle.wolips.wooeditor.editor.NonExistingFileEditorInput;

public class WooEditor
extends FormEditor {
    private WooModel model;
    private TextEditor myTextEditor;
    private DisplayGroupPage myDisplayGroupPage;
    private IResourceChangeListener resourceChangeListener;

    public boolean isDirty() {
        return this.model != null && this.model.isDirty() || super.isDirty();
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(WooeditorPlugin.getDefault().getFormColors(display));
    }

    protected void addPages() {
        try {
            this.myDisplayGroupPage = new DisplayGroupPage(this, "Display Groups");
            this.addPage((IFormPage)this.myDisplayGroupPage);
            this.myTextEditor = new TextEditor();
            IEditorInput input = this.getEditorInput();
            IFile file = ((FileEditorInput)input).getFile();
            if (!file.exists()) {
                try {
                    FileEditorInput fileInput = (FileEditorInput)input;
                    IFileStore fileStore = EFS.getStore((URI)fileInput.getURI());
                    input = new NonExistingFileEditorInput(fileStore, input.getName());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        CTabFolder ctf = (CTabFolder)this.getContainer();
        ctf.setBorderVisible(false);
        ctf.setTabPosition(128);
        if (this.getPageCount() <= 1) {
            ctf.setTabHeight(0);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.myTextEditor.isDirty() && (this.getActivePage() == 1 || !this.model.isDirty())) {
                IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
                if (!file.exists()) {
                    IEditorInput input = this.getEditorInput();
                    ((FileEditorInput)input).getFile().create((InputStream)new ByteArrayInputStream(this.model.toString().getBytes()), true, null);
                    this.myTextEditor.setInput(input);
                }
                this.myTextEditor.doSave(monitor);
                try {
                    this.model.doRevertToSaved();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.myDisplayGroupPage.refresh();
            } else {
                this.model.refactor(this.getSite().getShell(), (IRunnableContext)this.getSite().getWorkbenchWindow());
                this.model.doSave();
                this.myTextEditor.doRevertToSaved();
            }
            this.editorDirtyStateChanged();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("doSaveAs");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, final IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.getSite().getSelectionProvider().setSelection(new ISelection(){

            public boolean isEmpty() {
                return true;
            }
        });
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getDelta() == null || WooEditor.this.model == null) {
                    return;
                }
                IResourceDelta woComponentDelta = event.getDelta().findMember(((FileEditorInput)input).getFile().getFullPath().removeLastSegments(1).removeTrailingSeparator());
                if (woComponentDelta == null) {
                    return;
                }
                if (woComponentDelta.getKind() != 4 || (woComponentDelta.getFlags() & 0x100000) == 0) {
                    return;
                }
                IFolder folder = (IFolder)woComponentDelta.getResource();
                try {
                    WooEditor.this.model.setEncoding(folder.getDefaultCharset());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        workspace.addResourceChangeListener(this.resourceChangeListener);
    }

    public void dispose() {
        super.dispose();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.resourceChangeListener);
    }

    public WooModel getModel() {
        if (this.model == null) {
            IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
            if (file.exists()) {
                this.model = new WooModel(file);
                this.model.parseModel();
            } else {
                this.model = new WooModel(this.getEditorInput());
                this.model.parseModel();
                this.model.setEncoding(this.getComponentCharset());
            }
        }
        return this.model;
    }

    public void dropModel() {
        this.model = null;
    }

    public void activateFirstPage() {
        this.setActivePage(0);
    }

    protected void pageChange(int newPageIndex) {
        String modelText;
        super.pageChange(newPageIndex);
        if (newPageIndex == 0 && this.myTextEditor.isDirty()) {
            String editorText = this.myTextEditor.getDocumentProvider().getDocument((Object)this.myTextEditor.getEditorInput()).get();
            try {
                if (editorText != null && !editorText.equals(this.model.toString())) {
                    this.getModel().loadModelFromStream((InputStream)new ByteArrayInputStream(editorText.getBytes()));
                    this.getModel().parseModel();
                    this.myDisplayGroupPage.refresh();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (newPageIndex == 1 && this.getModel().isDirty() && (modelText = this.model.toString()) != null) {
            this.myTextEditor.getDocumentProvider().getDocument((Object)this.myTextEditor.getEditorInput()).set(modelText);
        }
    }

    public void setModel(WooModel model) {
        this.model = model;
    }

    private String getComponentCharset() {
        String encoding = "UTF-8";
        IEditorInput input = this.getEditorInput();
        if (input == null || !(input instanceof IFileEditorInput)) {
            return encoding;
        }
        IFile file = ((IFileEditorInput)input).getFile();
        try {
            encoding = file.getParent().getDefaultCharset();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        encoding = CharSetUtils.encodingNameFromObjectiveC((String)encoding);
        return encoding;
    }
}

