/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceDescriptor;
import org.eclipse.ltk.internal.core.refactoring.resource.RenameResourceProcessor;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.refactoring.RenameWOComponentChange;

public class RenameWOComponentProcessor
extends RenameResourceProcessor {
    private final IResource _resource;

    public RenameWOComponentProcessor(IResource resource) {
        super(resource);
        this._resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 1);
        try {
            String project = null;
            if (this._resource.getType() != 4) {
                project = this._resource.getProject().getName();
            }
            String header = Messages.format((String)"Renaming WO Component {0} to {1}", (Object[])new String[]{this._resource.getFullPath().toString(), this.getNewResourceName()});
            String description = Messages.format((String)"Renaming WO Component {0}", (Object)this._resource.getName());
            String comment = new JDTRefactoringDescriptorComment(project, (Object)this, header).asString();
            int flags = 7;
            RenameResourceDescriptor descriptor = new RenameResourceDescriptor();
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(7);
            descriptor.setResourcePath(this._resource.getLocation());
            descriptor.setNewName(this.getNewResourceName() + ".wo");
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange((Change)new RenameWOComponentChange((RefactoringDescriptor)descriptor, this._resource, this.getNewResourceName() + ".wo", comment));
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    public void setNewResourceName(String newName) {
        String name = LocatePlugin.getDefault().fileNameWithoutExtension(newName);
        super.setNewResourceName(name);
    }

    public RefactoringStatus validateNewElementName(String newName) {
        IProject project = this._resource.getProject();
        IJavaProject jProject = JavaCore.create((IProject)project);
        String sourceLevel = jProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String compliance = jProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        IStatus status = JavaConventions.validateCompilationUnitName((String)(newName + ".java"), (String)sourceLevel, (String)compliance);
        if (!status.isOK()) {
            return RefactoringStatus.create((IStatus)status);
        }
        return super.validateNewElementName(newName);
    }
}

