/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.locate;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.objectstyle.wolips.baseforplugins.AbstractBaseActivator;
import org.objectstyle.wolips.baseforplugins.util.ResourceUtilities;
import org.objectstyle.wolips.locate.Locate;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.locate.cache.ComponentLocateCache;
import org.objectstyle.wolips.locate.result.JavaLocateResult;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;
import org.objectstyle.wolips.locate.scope.ComponentLocateScope;
import org.objectstyle.wolips.locate.scope.JavaLocateScope;
import org.osgi.framework.BundleContext;

public class LocatePlugin
extends AbstractBaseActivator {
    private static LocatePlugin plugin;
    private ComponentLocateCache componentsLocateCache;

    public LocatePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.componentsLocateCache = new ComponentLocateCache();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.componentsLocateCache);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.componentsLocateCache);
        this.componentsLocateCache = null;
        plugin = null;
    }

    public static LocatePlugin getDefault() {
        return plugin;
    }

    public LocalizedComponentsLocateResult getLocalizedComponentsLocateResult(IResource resource) throws CoreException, LocateException {
        LocalizedComponentsLocateResult result = resource == null ? null : this.getLocalizedComponentsLocateResult(resource.getProject(), LocatePlugin.getDefault().fileNameWithoutExtension(resource));
        return result;
    }

    public LocalizedComponentsLocateResult getLocalizedComponentsLocateResult(IProject project, String filenameWithoutExtension) throws CoreException, LocateException {
        LocalizedComponentsLocateResult localizedComponentsLocateResult = this.componentsLocateCache.getLocalizedComponentsLocateResult(project, filenameWithoutExtension);
        if (localizedComponentsLocateResult != null) {
            return localizedComponentsLocateResult;
        }
        ComponentLocateScope componentLocateScope = ComponentLocateScope.createLocateScope(project, filenameWithoutExtension);
        localizedComponentsLocateResult = new LocalizedComponentsLocateResult();
        Locate locate = new Locate(componentLocateScope, localizedComponentsLocateResult);
        locate.locate();
        if (this.componentsLocateCache != null) {
            this.componentsLocateCache.addToCache(project, filenameWithoutExtension, localizedComponentsLocateResult);
        }
        return localizedComponentsLocateResult;
    }

    public JavaLocateResult getJavaLocateResult(String fileName, IProject project) throws CoreException, LocateException {
        JavaLocateScope javaLocateScope = JavaLocateScope.createLocateScope(fileName, project);
        JavaLocateResult javaLocateResult = new JavaLocateResult();
        Locate locate = new Locate(javaLocateScope, javaLocateResult);
        locate.locate();
        return javaLocateResult;
    }

    public String fileNameWithoutExtension(IResource file) {
        return ResourceUtilities.getFileNameWithoutExtension((IResource)file);
    }

    public String fileNameWithoutExtension(File file) {
        return ResourceUtilities.getFileNameWithoutExtension((File)file);
    }

    public String fileNameWithoutExtension(String fileName) {
        return ResourceUtilities.getFileNameWithoutExtension((String)fileName);
    }
}

