/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.locate.scope;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.scope.ILocateScope;

public abstract class AbstractProjectReferencesLocateScope
implements ILocateScope {
    private IProject project;
    private List<IProject> projects;
    private boolean findProjectsThatDependOnThis;
    private boolean findProjectsThatThisDependsOn;
    private boolean includeThis;

    public AbstractProjectReferencesLocateScope(IProject project, boolean findProjectsThatDependOnThis, boolean findProjectsThatThisDependOn, boolean includeThis) {
        this.project = project;
        this.includeThis = includeThis;
        this.findProjectsThatDependOnThis = findProjectsThatDependOnThis;
        this.findProjectsThatThisDependsOn = findProjectsThatThisDependOn;
    }

    @Override
    public boolean ignoreContainer(IContainer container) {
        if (container.getType() == 4) {
            return this.ignoreProject((IProject)container);
        }
        return this._ignoreContainer(container);
    }

    protected abstract boolean _ignoreContainer(IContainer var1);

    private boolean ignoreProject(IProject projectToValidate) {
        if (this.projects == null) {
            this.projects = new LinkedList<IProject>();
            IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            for (int projectNum = 0; projectNum < allProjects.length; ++projectNum) {
                if (this.includeThis && this.project.equals(allProjects[projectNum])) {
                    this.projects.add(allProjects[projectNum]);
                    continue;
                }
                if ((!this.findProjectsThatDependOnThis || !this.doesProjectDependOnProject(allProjects[projectNum], this.project)) && (!this.findProjectsThatThisDependsOn || !this.doesProjectDependOnProject(this.project, allProjects[projectNum]))) continue;
                this.projects.add(allProjects[projectNum]);
            }
        }
        return !this.projects.contains(projectToValidate);
    }

    private boolean doesProjectDependOnProject(IProject _project, IProject _maybeDependsOnProject) {
        boolean projectIsDependedOn = false;
        try {
            if (_project.isOpen() || _project.isAccessible()) {
                IProject[] referencedProjects = _project.getReferencedProjects();
                for (int projectNum = 0; !projectIsDependedOn && projectNum < referencedProjects.length; ++projectNum) {
                    projectIsDependedOn = referencedProjects[projectNum].equals(_maybeDependsOnProject);
                }
            }
        }
        catch (Exception anException) {
            LocatePlugin.getDefault().log(anException);
        }
        return projectIsDependedOn;
    }
}

