/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public abstract class Nature
implements IProjectNature {
    private IProject project;

    public abstract String getBuilderID();

    public void configure() throws CoreException {
        if (!this.isBuilderInstalled(this.getBuilderID())) {
            this.installBuilder(this.getBuilderID());
        }
    }

    public void deconfigure() throws CoreException {
        if (this.isBuilderInstalled(this.getBuilderID())) {
            this.removeBuilder(this.getBuilderID());
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public abstract boolean isFramework();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installBuilder(String aBuilder) throws CoreException {
        IProjectDescription desc = null;
        ICommand[] coms = null;
        ICommand[] newIc = null;
        ICommand command = null;
        try {
            desc = this.getProject().getDescription();
            coms = desc.getBuildSpec();
            boolean foundJBuilder = false;
            for (int i = 0; i < coms.length; ++i) {
                if (!coms[i].getBuilderName().equals(aBuilder)) continue;
                foundJBuilder = true;
            }
            if (!foundJBuilder) {
                command = desc.newCommand();
                command.setBuilderName(aBuilder);
                newIc = new ICommand[coms.length + 1];
                System.arraycopy(coms, 0, newIc, 0, coms.length);
                newIc[coms.length] = command;
                desc.setBuildSpec(newIc);
                this.getProject().setDescription(desc, null);
            }
        }
        finally {
            desc = null;
            coms = null;
            newIc = null;
            command = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBuilder(String aBuilder) throws CoreException {
        IProjectDescription desc = null;
        ICommand[] coms = null;
        ArrayList<ICommand> comList = null;
        List<ICommand> tmp = null;
        ICommand[] newCom = null;
        try {
            int i;
            desc = this.getProject().getDescription();
            coms = desc.getBuildSpec();
            comList = new ArrayList<ICommand>();
            tmp = Arrays.asList(coms);
            comList.addAll(tmp);
            boolean foundJBuilder = false;
            for (i = 0; i < comList.size(); ++i) {
                if (!((ICommand)comList.get(i)).getBuilderName().equals(aBuilder)) continue;
                comList.remove(i);
                foundJBuilder = true;
            }
            if (foundJBuilder) {
                newCom = new ICommand[comList.size()];
                for (i = 0; i < comList.size(); ++i) {
                    newCom[i] = (ICommand)comList.get(i);
                }
                desc.setBuildSpec(newCom);
                this.getProject().setDescription(desc, null);
            }
        }
        finally {
            desc = null;
            coms = null;
            comList = null;
            tmp = null;
            newCom = null;
        }
    }

    private boolean isBuilderInstalled(String anID) throws CoreException {
        ICommand[] nids = this.getProject().getDescription().getBuildSpec();
        for (int i = 0; i < nids.length; ++i) {
            if (!nids[i].getBuilderName().equals(anID)) continue;
            return true;
        }
        return false;
    }
}

