/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.types;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.search.AbstractSearchScope;
import org.objectstyle.wolips.core.resources.types.SubTypeHierarchyCache;

public class WOHierarchyScope
extends AbstractSearchScope
implements SuffixConstants {
    private IJavaProject javaProject;
    public IType focusType;
    private String focusPath;
    private ITypeHierarchy hierarchy;
    private IType[] types;
    private Set resourcePaths;
    private IPath[] enclosingProjectsAndJars;
    protected IResource[] elements;
    protected int elementCount;
    public boolean needsRefresh;
    private static Map<IProject, WOHierarchyScopeCacheEntry> _hierarchyScopeCache = new HashMap<IProject, WOHierarchyScopeCacheEntry>();

    public void add(IResource element) {
        if (this.elementCount == this.elements.length) {
            this.elements = new IResource[this.elementCount * 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.elementCount);
        }
        this.elements[this.elementCount++] = element;
    }

    public WOHierarchyScope(IType type, IJavaProject javaProject) throws JavaModelException {
        this.focusType = type;
        this.javaProject = javaProject;
        this.enclosingProjectsAndJars = this.computeProjectsAndJars(type);
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        if (root.isArchive()) {
            String zipFileName;
            IPath jarPath = root.getPath();
            Object target = JavaModel.getTarget((IPath)jarPath, (boolean)true);
            if (target instanceof IFile) {
                zipFileName = jarPath.toString();
            } else if (target instanceof File) {
                zipFileName = ((File)target).getPath();
            } else {
                return;
            }
            this.focusPath = zipFileName + "|" + type.getFullyQualifiedName().replace('.', '/') + ".class";
        } else {
            this.focusPath = type.getPath().toString();
        }
        this.needsRefresh = true;
    }

    private void buildResourceVector() {
        int i;
        HashMap<IResource, IResource> resources = new HashMap<IResource, IResource>();
        HashMap<IPath, IType> paths = new HashMap<IPath, IType>();
        this.types = this.hierarchy.getAllTypes();
        for (i = 0; i < this.types.length; ++i) {
            IPackageFragmentRoot root;
            IType type = this.types[i];
            IResource resource = ((JavaElement)type).resource();
            if (resource != null && resources.get(resource) == null) {
                resources.put(resource, resource);
                this.add(resource);
            }
            if ((root = (IPackageFragmentRoot)type.getPackageFragment().getParent()) instanceof JarPackageFragmentRoot) {
                String zipFileName;
                JarPackageFragmentRoot jar = (JarPackageFragmentRoot)root;
                IPath jarPath = jar.getPath();
                Object target = JavaModel.getTarget((IPath)jarPath, (boolean)true);
                if (target instanceof IFile) {
                    zipFileName = jarPath.toString();
                } else {
                    if (!(target instanceof File)) continue;
                    zipFileName = ((File)target).getPath();
                }
                String resourcePath = zipFileName + "|" + type.getFullyQualifiedName().replace('.', '/') + ".class";
                this.resourcePaths.add(resourcePath);
                paths.put(jarPath, type);
                continue;
            }
            paths.put(type.getJavaProject().getProject().getFullPath(), type);
        }
        this.enclosingProjectsAndJars = new IPath[paths.size()];
        i = 0;
        Iterator iter = paths.keySet().iterator();
        while (iter.hasNext()) {
            this.enclosingProjectsAndJars[i++] = (IPath)iter.next();
        }
    }

    private IPath[] computeProjectsAndJars(IType type) throws JavaModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        if (root.isArchive()) {
            set.add(root.getPath());
            IPath rootPath = root.getPath();
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaProject[] projects = model.getJavaProjects();
            HashSet visited = new HashSet();
            for (int i = 0; i < projects.length; ++i) {
                JavaProject project = (JavaProject)projects[i];
                IClasspathEntry entry = project.getClasspathEntryFor(rootPath);
                if (entry == null) continue;
                IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
                set.add(project.getPath());
                for (int k = 0; k < roots.length; ++k) {
                    IPackageFragmentRoot pkgFragmentRoot = roots[k];
                    if (pkgFragmentRoot.getKind() != 2) continue;
                    set.add(pkgFragmentRoot.getPath());
                }
                this.computeDependents((IJavaProject)project, set, visited);
            }
        } else {
            IJavaProject project = (IJavaProject)root.getParent();
            IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
            for (int i = 0; i < roots.length; ++i) {
                IPackageFragmentRoot pkgFragmentRoot = roots[i];
                if (pkgFragmentRoot.getKind() == 2) {
                    set.add(pkgFragmentRoot.getPath());
                    continue;
                }
                set.add(pkgFragmentRoot.getParent().getPath());
            }
            this.computeDependents(project, set, new HashSet());
        }
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    private void computeDependents(IJavaProject project, HashSet set, HashSet visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject[] dependents = project.getProject().getReferencingProjects();
        for (int i = 0; i < dependents.length; ++i) {
            try {
                IJavaProject dependent = JavaCore.create((IProject)dependents[i]);
                IPackageFragmentRoot[] roots = dependent.getPackageFragmentRoots();
                set.add(dependent.getPath());
                for (int j = 0; j < roots.length; ++j) {
                    IPackageFragmentRoot pkgFragmentRoot = roots[j];
                    if (!pkgFragmentRoot.isArchive()) continue;
                    set.add(pkgFragmentRoot.getPath());
                }
                this.computeDependents(dependent, set, visited);
                continue;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    public boolean encloses(String resourcePath) {
        int separatorIndex;
        if (this.hierarchy == null) {
            if (resourcePath.equals(this.focusPath)) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (JavaModelException e) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        if ((separatorIndex = resourcePath.indexOf("|")) != -1) {
            return this.resourcePaths.contains(resourcePath);
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (!resourcePath.startsWith(this.elements[i].getFullPath().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean encloses(IJavaElement element) {
        if (this.hierarchy == null) {
            if (this.focusType.equals(element.getAncestor(7))) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (JavaModelException e) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        IType type = null;
        if (element instanceof IType) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        if (type != null) {
            IType original;
            if (this.hierarchy.contains(type)) {
                return true;
            }
            if (!type.isBinary() && (original = (IType)type.getPrimaryElement()) != null) {
                return this.hierarchy.contains(original);
            }
        }
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (JavaModelException e) {
                return new IPath[0];
            }
        }
        return this.enclosingProjectsAndJars;
    }

    public void processDelta(IJavaElementDelta delta, int eventType) {
        if (this.needsRefresh) {
            return;
        }
        this.needsRefresh = this.hierarchy == null ? false : ((TypeHierarchy)this.hierarchy).isAffected(delta, eventType);
    }

    protected void refresh() throws JavaModelException {
        if (this.hierarchy != null) {
            this.initialize();
        }
    }

    public String toString() {
        return "WOHierarchyScope on " + ((JavaElement)this.focusType).toStringWithAncestors();
    }

    protected void initialize() throws JavaModelException {
        this.resourcePaths = Collections.synchronizedSet(new HashSet());
        this.elements = new IResource[5];
        this.elementCount = 0;
        this.needsRefresh = false;
        if (this.hierarchy == null) {
            this.hierarchy = SubTypeHierarchyCache.getTypeHierarchyInProject(this.focusType, this.javaProject, null);
        } else {
            this.hierarchy.refresh(null);
        }
        this.buildResourceVector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WOHierarchyScope hierarchyScope(IType superclassType, IProject project) throws JavaModelException {
        WOHierarchyScopeCacheEntry scopeCacheEntry;
        Map<IProject, WOHierarchyScopeCacheEntry> map = _hierarchyScopeCache;
        synchronized (map) {
            scopeCacheEntry = _hierarchyScopeCache.get(project);
        }
        if (scopeCacheEntry == null) {
            scopeCacheEntry = new WOHierarchyScopeCacheEntry(project);
        }
        return scopeCacheEntry.hierarchyScopeForType(superclassType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCacheForProject(IProject project) {
        Map<IProject, WOHierarchyScopeCacheEntry> map = _hierarchyScopeCache;
        synchronized (map) {
            _hierarchyScopeCache.remove(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WOHierarchyScopeCacheEntry incrementReferenceCountForProject(IProject project) {
        WOHierarchyScopeCacheEntry scopeCacheEntry;
        Map<IProject, WOHierarchyScopeCacheEntry> map = _hierarchyScopeCache;
        synchronized (map) {
            scopeCacheEntry = _hierarchyScopeCache.get(project);
            if (scopeCacheEntry == null) {
                scopeCacheEntry = new WOHierarchyScopeCacheEntry(project);
                _hierarchyScopeCache.put(project, scopeCacheEntry);
            }
            ++scopeCacheEntry.referenceCount;
        }
        return scopeCacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrementReferenceCountForProject(IProject project) {
        Map<IProject, WOHierarchyScopeCacheEntry> map = _hierarchyScopeCache;
        synchronized (map) {
            WOHierarchyScopeCacheEntry scopeCacheEntry = _hierarchyScopeCache.get(project);
            if (scopeCacheEntry != null) {
                --scopeCacheEntry.referenceCount;
                if (scopeCacheEntry.referenceCount <= 0) {
                    WOHierarchyScope.clearCacheForProject(project);
                }
            }
        }
    }

    protected static class WOHierarchyScopeCacheEntry {
        public IProject project;
        public int referenceCount;
        public Map<IType, WOHierarchyScope> scopes = new HashMap<IType, WOHierarchyScope>();

        public WOHierarchyScopeCacheEntry(IProject project) {
            this.project = project;
        }

        public synchronized WOHierarchyScope hierarchyScopeForType(IType type) throws JavaModelException {
            WOHierarchyScope scope = this.scopes.get(type);
            if (scope == null) {
                scope = new WOHierarchyScope(type, JavaCore.create((IProject)this.project));
                this.scopes.put(type, scope);
            }
            return scope;
        }
    }
}

