/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.types;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaModelException;

public class SubTypeHierarchyCache {
    private static final int CACHE_SIZE = 24;
    private static List<HierarchyCacheEntry> fgHierarchyCache = new ArrayList<HierarchyCacheEntry>(24);
    private static int fgCacheHits = 0;
    private static int fgCacheMisses = 0;

    public static ITypeHierarchy getTypeHierarchyInProject(IType type, IJavaProject project) throws JavaModelException {
        return SubTypeHierarchyCache.getTypeHierarchyInProject(type, project, null);
    }

    public static ITypeHierarchy getTypeHierarchyInProject(IType type, IJavaProject project, IProgressMonitor progressMonitor) throws JavaModelException {
        ITypeHierarchy hierarchy = SubTypeHierarchyCache.findTypeHierarchyInProjectInCache(type, project);
        if (hierarchy == null) {
            ++fgCacheMisses;
            hierarchy = project != null ? type.newTypeHierarchy(project, progressMonitor) : type.newTypeHierarchy(progressMonitor);
            SubTypeHierarchyCache.addTypeHierarchyInProjectToCache(hierarchy, project);
        } else {
            ++fgCacheHits;
        }
        return hierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTypeHierarchyInProjectToCache(ITypeHierarchy hierarchy, IJavaProject project) {
        List<HierarchyCacheEntry> list = fgHierarchyCache;
        synchronized (list) {
            int nEntries = fgHierarchyCache.size();
            if (nEntries >= 24) {
                int i;
                HierarchyCacheEntry oldest = null;
                ArrayList<HierarchyCacheEntry> obsoleteHierarchies = new ArrayList<HierarchyCacheEntry>(24);
                for (i = 0; i < nEntries; ++i) {
                    HierarchyCacheEntry entry = fgHierarchyCache.get(i);
                    ITypeHierarchy curr = entry.getTypeHierarchy();
                    if (!curr.exists() || hierarchy.contains(curr.getType())) {
                        obsoleteHierarchies.add(entry);
                        continue;
                    }
                    if (oldest != null && entry.getLastAccess() >= oldest.getLastAccess()) continue;
                    oldest = entry;
                }
                if (!obsoleteHierarchies.isEmpty()) {
                    for (i = 0; i < obsoleteHierarchies.size(); ++i) {
                        SubTypeHierarchyCache.removeHierarchyEntryFromCache((HierarchyCacheEntry)obsoleteHierarchies.get(i));
                    }
                } else if (oldest != null) {
                    SubTypeHierarchyCache.removeHierarchyEntryFromCache(oldest);
                }
            }
            HierarchyCacheEntry newEntry = new HierarchyCacheEntry(hierarchy, project);
            fgHierarchyCache.add(newEntry);
        }
    }

    public static boolean hasInCacheInProject(IType type, IJavaProject project) {
        return SubTypeHierarchyCache.findTypeHierarchyInProjectInCache(type, project) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ITypeHierarchy findTypeHierarchyInProjectInCache(IType type, IJavaProject project) {
        List<HierarchyCacheEntry> list = fgHierarchyCache;
        synchronized (list) {
            for (int i = fgHierarchyCache.size() - 1; i >= 0; --i) {
                HierarchyCacheEntry curr = fgHierarchyCache.get(i);
                ITypeHierarchy hierarchy = curr.getTypeHierarchy();
                if (!hierarchy.exists()) {
                    SubTypeHierarchyCache.removeHierarchyEntryFromCache(curr);
                    continue;
                }
                if ((project != null || curr.getProject() != null) && (project == null || !project.equals(curr.getProject())) || !hierarchy.contains(type)) continue;
                curr.markAsAccessed();
                return hierarchy;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeHierarchyEntryFromCache(HierarchyCacheEntry entry) {
        List<HierarchyCacheEntry> list = fgHierarchyCache;
        synchronized (list) {
            entry.dispose();
            fgHierarchyCache.remove(entry);
        }
    }

    public static int getCacheHits() {
        return fgCacheHits;
    }

    public static int getCacheMisses() {
        return fgCacheMisses;
    }

    private static class HierarchyCacheEntry
    implements ITypeHierarchyChangedListener {
        private IJavaProject fProject;
        private ITypeHierarchy fTypeHierarchy;
        private long fLastAccess;

        public HierarchyCacheEntry(ITypeHierarchy hierarchy, IJavaProject project) {
            this.fTypeHierarchy = hierarchy;
            this.fTypeHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.fProject = project;
            this.markAsAccessed();
        }

        public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
            SubTypeHierarchyCache.removeHierarchyEntryFromCache(this);
        }

        public ITypeHierarchy getTypeHierarchy() {
            return this.fTypeHierarchy;
        }

        public void markAsAccessed() {
            this.fLastAccess = System.currentTimeMillis();
        }

        public long getLastAccess() {
            return this.fLastAccess;
        }

        public IJavaProject getProject() {
            return this.fProject;
        }

        public void dispose() {
            this.fTypeHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.fTypeHierarchy = null;
        }

        public String toString() {
            return "Sub hierarchy of: " + this.fTypeHierarchy.getType().getElementName();
        }
    }
}

