/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.types.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.objectstyle.wolips.baseforplugins.util.WOLipsNatureUtils;
import org.objectstyle.wolips.core.CorePlugin;
import org.objectstyle.wolips.core.resources.internal.build.AntApplicationNature;
import org.objectstyle.wolips.core.resources.internal.build.AntFrameworkNature;
import org.objectstyle.wolips.core.resources.internal.types.AbstractResourceAdapter;
import org.objectstyle.wolips.core.resources.types.IPBDotProjectOwner;
import org.objectstyle.wolips.core.resources.types.file.IPBDotProjectAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IBuildAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotApplicationAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotFrameworkAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IProductAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IWoprojectAdapter;
import org.objectstyle.wolips.core.resources.types.project.IProjectPatternsets;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.variables.VariablesPlugin;

public class ProjectAdapter
extends AbstractResourceAdapter
implements IPBDotProjectOwner {
    private IProject _underlyingProject;
    private boolean _isFramework;
    public static final int BuilderNotFound = -1;
    protected static final String TARGET_BUILDER_ID = "org.objectstyle.wolips.targetbuilder.targetbuilder";
    protected static final String INCREMENTAL_BUILDER_ID = "org.objectstyle.wolips.incrementalbuilder";
    private static final String ANT_BUILDER_ID = "org.objectstyle.wolips.antbuilder";

    public ProjectAdapter(IProject project, boolean isFramework) {
        super((IResource)project);
        this._underlyingProject = project;
        this._isFramework = isFramework;
    }

    public IProject getUnderlyingProject() {
        return this._underlyingProject;
    }

    public String getBundleName() {
        return this.getUnderlyingProject().getName();
    }

    public boolean isMaven() {
        return WOLipsNatureUtils.isMavenNature((IProject)this.getUnderlyingProject());
    }

    public boolean isFramework() {
        return this._isFramework;
    }

    public boolean isApplication() {
        return !this.isFramework();
    }

    @Override
    public IPBDotProjectAdapter getPBDotProjectAdapter() {
        IProject underlyingContainer = this.getUnderlyingProject();
        IFile pbDotProjectResource = underlyingContainer.getFile((IPath)new Path("PB.project"));
        IPBDotProjectAdapter pbDotProjectAdapter = (IPBDotProjectAdapter)pbDotProjectResource.getAdapter(IPBDotProjectAdapter.class);
        return pbDotProjectAdapter;
    }

    public IWoprojectAdapter getWoprojectAdapter() {
        IProject underlyingContainer = this.getUnderlyingProject();
        IFolder wprojectFolder = null;
        IWoprojectAdapter wprojectAdapter = null;
        wprojectFolder = underlyingContainer.getFolder((IPath)new Path("woproject"));
        if (wprojectFolder.exists() && (wprojectAdapter = (IWoprojectAdapter)wprojectFolder.getAdapter(IWoprojectAdapter.class)) != null) {
            return wprojectAdapter;
        }
        wprojectFolder = underlyingContainer.getFolder((IPath)new Path("ant"));
        if (wprojectFolder.exists()) {
            wprojectAdapter = (IWoprojectAdapter)wprojectFolder.getAdapter(IWoprojectAdapter.class);
        }
        return wprojectAdapter;
    }

    @Override
    public IPBDotProjectOwner getPBDotProjectOwner(IResource resource) {
        if (resource == this.getUnderlyingProject()) {
            return this;
        }
        return super.getPBDotProjectOwner(resource);
    }

    @Override
    public IPBDotProjectOwner getPBDotProjectOwner() {
        return this;
    }

    @Override
    public boolean hasParentPBDotProjectAdapter() {
        return false;
    }

    private IFolder getBuildFolder() {
        IFolder resource = this.getUnderlyingProject().getFolder("dist");
        if (resource.exists() && resource instanceof IFolder) {
            return resource;
        }
        resource = this.getUnderlyingProject().getFolder("build");
        if (resource.exists() && resource instanceof IFolder) {
            return resource;
        }
        return null;
    }

    public IBuildAdapter getBuildAdapter() {
        IFolder resource = this.getBuildFolder();
        if (resource == null) {
            return null;
        }
        return (IBuildAdapter)resource.getAdapter(IBuildAdapter.class);
    }

    public IDotApplicationAdapter getDotApplicationAdapter() {
        IFolder resource = this.getUnderlyingProject().getFolder(this.getUnderlyingResource().getProject().getName() + ".woa");
        return (IDotApplicationAdapter)resource.getAdapter(IDotApplicationAdapter.class);
    }

    public IDotFrameworkAdapter getDotFrameworkAdapter() {
        IFolder resource = this.getUnderlyingProject().getFolder(this.getUnderlyingResource().getProject().getName() + ".framework");
        return (IDotFrameworkAdapter)resource.getAdapter(IDotFrameworkAdapter.class);
    }

    public IProductAdapter getProductAdapter() {
        if (this.isFramework()) {
            return this.getDotFrameworkAdapter();
        }
        return this.getDotApplicationAdapter();
    }

    public void installTargetBuilder(int position) throws CoreException {
        if (!this.isTargetBuilderInstalled()) {
            this.installBuilderAtPosition(TARGET_BUILDER_ID, position, null);
        }
    }

    public int removeTargetBuilder() throws CoreException {
        if (!this.isTargetBuilderInstalled()) {
            return -1;
        }
        int returnValue = this.positionForBuilder(TARGET_BUILDER_ID);
        this.removeBuilder(TARGET_BUILDER_ID);
        return returnValue;
    }

    public void installAntBuilder() throws CoreException {
        if (!this.isAntBuilderInstalled()) {
            this.installBuilder(ANT_BUILDER_ID);
        }
    }

    public void removeAntBuilder() throws CoreException {
        if (this.isAntBuilderInstalled()) {
            this.removeBuilder(ANT_BUILDER_ID);
        }
    }

    public void installIncrementalBuilder() throws CoreException {
        if (!this.isIncrementalBuilderInstalled()) {
            this.installBuilder(INCREMENTAL_BUILDER_ID);
        }
    }

    public void removeIncrementalBuilder() throws CoreException {
        if (this.isIncrementalBuilderInstalled()) {
            this.removeBuilder(INCREMENTAL_BUILDER_ID);
        }
    }

    public void installJavaBuilder() throws CoreException {
        if (!this.isJavaBuilderInstalled()) {
            this.installBuilder("org.eclipse.jdt.core.javabuilder");
        }
    }

    public void installJavaBuilder(int position) throws CoreException {
        if (!this.isJavaBuilderInstalled()) {
            this.installBuilderAtPosition("org.eclipse.jdt.core.javabuilder", position, null);
        }
    }

    public int removeJavaBuilder() throws CoreException {
        if (!this.isJavaBuilderInstalled()) {
            return -1;
        }
        int returnValue = this.positionForBuilder("org.eclipse.jdt.core.javabuilder");
        this.removeBuilder("org.eclipse.jdt.core.javabuilder");
        return returnValue;
    }

    public boolean isTargetBuilderInstalled() {
        return this.isBuilderInstalled(TARGET_BUILDER_ID);
    }

    public boolean isAntBuilderInstalled() {
        return this.isBuilderInstalled(ANT_BUILDER_ID);
    }

    public boolean isIncrementalBuilderInstalled() {
        return this.isBuilderInstalled(INCREMENTAL_BUILDER_ID);
    }

    public boolean isJavaBuilderInstalled() {
        return this.isBuilderInstalled("org.eclipse.jdt.core.javabuilder");
    }

    public Map getBuilderArgs() {
        Map result = null;
        try {
            IProjectDescription desc = this.getUnderlyingProject().getDescription();
            List<ICommand> cmdList = Arrays.asList(desc.getBuildSpec());
            for (ICommand cmd : cmdList) {
                if (!this.isWOLipsBuilder(cmd.getBuilderName())) continue;
                result = cmd.getArguments();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == result) {
            result = Collections.EMPTY_MAP;
        }
        return result;
    }

    private boolean isWOLipsBuilder(String name) {
        return name.equals(INCREMENTAL_BUILDER_ID) || name.equals(ANT_BUILDER_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBuilder(String aBuilder) throws CoreException {
        IProjectDescription desc = null;
        ICommand[] coms = null;
        ArrayList<ICommand> comList = null;
        List<ICommand> tmp = null;
        ICommand[] newCom = null;
        try {
            int i;
            desc = this.getUnderlyingProject().getDescription();
            coms = desc.getBuildSpec();
            comList = new ArrayList<ICommand>();
            tmp = Arrays.asList(coms);
            comList.addAll(tmp);
            boolean foundJBuilder = false;
            for (i = 0; i < comList.size(); ++i) {
                if (!((ICommand)comList.get(i)).getBuilderName().equals(aBuilder)) continue;
                comList.remove(i);
                foundJBuilder = true;
            }
            if (foundJBuilder) {
                newCom = new ICommand[comList.size()];
                for (i = 0; i < comList.size(); ++i) {
                    newCom[i] = (ICommand)comList.get(i);
                }
                desc.setBuildSpec(newCom);
                this.getUnderlyingProject().setDescription(desc, null);
            }
        }
        finally {
            desc = null;
            coms = null;
            comList = null;
            tmp = null;
            newCom = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installBuilder(String aBuilder) throws CoreException {
        IProjectDescription desc = null;
        ICommand[] coms = null;
        ICommand[] newIc = null;
        ICommand command = null;
        try {
            desc = this.getUnderlyingProject().getDescription();
            coms = desc.getBuildSpec();
            boolean foundJBuilder = false;
            for (int i = 0; i < coms.length; ++i) {
                if (!coms[i].getBuilderName().equals(aBuilder)) continue;
                foundJBuilder = true;
            }
            if (!foundJBuilder) {
                command = desc.newCommand();
                command.setBuilderName(aBuilder);
                newIc = new ICommand[coms.length + 1];
                System.arraycopy(coms, 0, newIc, 0, coms.length);
                newIc[coms.length] = command;
                desc.setBuildSpec(newIc);
                this.getUnderlyingProject().setDescription(desc, null);
            }
        }
        finally {
            desc = null;
            coms = null;
            newIc = null;
            command = null;
        }
    }

    private boolean isBuilderInstalled(String anID) {
        try {
            ICommand[] nids = this.getUnderlyingProject().getDescription().getBuildSpec();
            for (int i = 0; i < nids.length; ++i) {
                if (!nids[i].getBuilderName().equals(anID)) continue;
                return true;
            }
        }
        catch (Exception anException) {
            CorePlugin.getDefault().log(anException);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int positionForBuilder(String aBuilder) throws CoreException {
        IProjectDescription desc = null;
        ICommand[] coms = null;
        try {
            desc = this.getUnderlyingProject().getDescription();
            coms = desc.getBuildSpec();
            for (int i = 0; i < coms.length; ++i) {
                if (!coms[i].getBuilderName().equals(aBuilder)) continue;
                int n = i;
                return n;
            }
        }
        finally {
            desc = null;
            coms = null;
        }
        return -1;
    }

    private void installBuilderAtPosition(String aBuilder, int installPos, Map arguments) throws CoreException {
        if (installPos == -1) {
            CorePlugin.getDefault().log("Somebody tries to install builder: " + aBuilder + " at an illegal position. This may happen if the removed builder does not exist.");
            return;
        }
        IProjectDescription desc = this.getUnderlyingProject().getDescription();
        ICommand[] coms = desc.getBuildSpec();
        HashMap args = arguments;
        if (args == null) {
            args = new HashMap();
        }
        for (int i = 0; i < coms.length; ++i) {
            if (!coms[i].getBuilderName().equals(aBuilder) || !coms[i].getArguments().equals(args)) continue;
            return;
        }
        ICommand[] newIc = null;
        ICommand command = desc.newCommand();
        command.setBuilderName(aBuilder);
        command.setArguments(args);
        newIc = new ICommand[coms.length + 1];
        if (installPos <= 0) {
            System.arraycopy(coms, 0, newIc, 1, coms.length);
            newIc[0] = command;
        } else if (installPos >= coms.length) {
            System.arraycopy(coms, 0, newIc, 0, coms.length);
            newIc[coms.length] = command;
        } else {
            System.arraycopy(coms, 0, newIc, 0, installPos);
            newIc[installPos] = command;
            System.arraycopy(coms, installPos, newIc, installPos + 1, coms.length - installPos);
        }
        desc.setBuildSpec(newIc);
        this.getUnderlyingProject().setDescription(desc, null);
    }

    public IPath getWorkingDir() throws CoreException {
        IPath path = null;
        IContainer workingDirFolder = this.getWorkingDirFolder();
        if (workingDirFolder != null && workingDirFolder.exists()) {
            path = workingDirFolder.getLocation();
        }
        return path;
    }

    protected boolean mockBundlesEnabled() {
        return Platform.getPreferencesService().getBoolean("org.objectstyle.wolips.preferences", "org.objectstyle.wolips.preference.MockBundleEnabled", true, null);
    }

    public IContainer getWorkingDirFolder() throws CoreException {
        Object workingDirFolder;
        IProject project = this.getUnderlyingProject();
        BuildProperties buildProperties = (BuildProperties)project.getAdapter(BuildProperties.class);
        if (buildProperties.getWOVersion().isAtLeastVersion(5, 6) || !this.mockBundlesEnabled()) {
            workingDirFolder = project;
        } else {
            workingDirFolder = this.isAntBuilderInstalled() || WOLipsNatureUtils.getNature((IProject)project) instanceof AntApplicationNature ? this.getUnderlyingProject().getFolder("dist") : this.getUnderlyingProject().getFolder("build");
            if (workingDirFolder != null && workingDirFolder.exists()) {
                IFolder woaFolder = null;
                IResource[] members = workingDirFolder.members();
                for (int i = 0; woaFolder == null && i < members.length; ++i) {
                    IResource member = members[i];
                    if (member.getType() != 2 || !member.getName().endsWith(".woa")) continue;
                    woaFolder = (IFolder)member;
                }
                workingDirFolder = woaFolder != null && woaFolder.exists() ? woaFolder : null;
            } else {
                workingDirFolder = null;
            }
        }
        return workingDirFolder;
    }

    public IPath getWOJavaArchive() throws CoreException {
        IPath path = null;
        IProject project = this.getUnderlyingProject();
        BuildProperties buildProperties = (BuildProperties)project.getAdapter(BuildProperties.class);
        if (buildProperties.getWOVersion().isAtLeastVersion(5, 6) || !this.mockBundlesEnabled()) {
            path = this.getUnderlyingProject().getLocation();
        } else {
            IResource resource = null;
            String projectName = project.getName();
            if (this.isFramework()) {
                if (this.isAntBuilderInstalled() || WOLipsNatureUtils.getNature((IProject)project) instanceof AntFrameworkNature) {
                    resource = this.getJar("dist/", ".framework/");
                    if (!resource.exists()) {
                        resource = this.getJar("", ".framework/");
                    }
                } else if (this.isIncrementalBuilderInstalled()) {
                    resource = this.getUnderlyingProject().getFolder("build/" + projectName + ".framework/Resources/Java");
                }
                if (resource != null && resource.exists()) {
                    path = resource.getLocation();
                } else {
                    IPath externalBuildRoot = VariablesPlugin.getDefault().getProjectVariables(this._underlyingProject).getExternalBuildRoot();
                    if (externalBuildRoot != null) {
                        path = externalBuildRoot.append(projectName + ".framework/Resources/Java/" + projectName + ".jar");
                    }
                }
            } else if (this.isApplication()) {
                IContainer wdFolder = this.getWorkingDirFolder();
                if (wdFolder != null && wdFolder.exists()) {
                    IFolder javaFolder = wdFolder.getFolder((IPath)new Path("Contents/Resources/Java"));
                    if (this.isAntBuilderInstalled() || WOLipsNatureUtils.getNature((IProject)project) instanceof AntApplicationNature) {
                        resource = javaFolder.findMember(wdFolder.getName().substring(0, wdFolder.getName().length() - 4).toLowerCase() + ".jar");
                        if (!resource.exists()) {
                            resource = this.getJar("", ".woa/Contents/");
                        }
                    } else if (this.isIncrementalBuilderInstalled()) {
                        resource = javaFolder;
                    }
                }
                if (resource != null && resource.exists()) {
                    path = resource.getLocation();
                } else {
                    IPath externalBuildRoot = VariablesPlugin.getDefault().getProjectVariables(this._underlyingProject).getExternalBuildRoot();
                    if (externalBuildRoot != null) {
                        path = externalBuildRoot.append(projectName + ".woa/Contents/Resources/Java/" + projectName + ".jar");
                    }
                }
            }
        }
        return path;
    }

    private IResource getJar(String prefix, String postfix) {
        IFile result = null;
        String projectName = this.getUnderlyingProject().getName();
        result = this.getUnderlyingProject().getFile(prefix + projectName + postfix + "Resources/Java/" + projectName + ".jar");
        if (result == null || !result.exists()) {
            result = this.getUnderlyingProject().getFile(prefix + projectName + postfix + "Resources/Java/" + projectName.toLowerCase() + ".jar");
        }
        return result;
    }

    public BuildProperties getBuildProperties() {
        return (BuildProperties)this._underlyingProject.getAdapter(BuildProperties.class);
    }

    public boolean isResource(IResource resource) {
        IProjectPatternsets patternsets = (IProjectPatternsets)this.getUnderlyingProject().getAdapter(IProjectPatternsets.class);
        boolean isResource = patternsets.matchesResourcesPattern(resource);
        return isResource;
    }

    public boolean isResourceContainer(IContainer container) {
        return this.isResource((IResource)container.getFolder((IPath)new Path("Random.eomodeld")));
    }

    public IContainer getDefaultResourcesFolder() {
        IProject project = this.getUnderlyingProject();
        IFolder resourcesFolder = project.getFolder("Resources");
        if (!resourcesFolder.exists()) {
            if (this.isMaven()) {
                resourcesFolder = project.getFolder((IPath)new Path("src/main/resources"));
                if (!resourcesFolder.exists()) {
                    resourcesFolder = project;
                }
            } else {
                resourcesFolder = project;
            }
        }
        return resourcesFolder;
    }

    public boolean isComponentsContainer(IContainer container) {
        return this.isResource((IResource)container.getFolder((IPath)new Path("Random.wo")));
    }

    public IContainer getDefaultComponentsFolder() {
        IProject project = this.getUnderlyingProject();
        IFolder componentsFolder = project.getFolder("Components");
        if (!componentsFolder.exists()) {
            if (this.isMaven()) {
                componentsFolder = project.getFolder((IPath)new Path("src/main/components"));
                if (!componentsFolder.exists()) {
                    componentsFolder = project;
                }
            } else {
                componentsFolder = project;
            }
        }
        return componentsFolder;
    }
}

