/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.womodeler.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.objectstyle.wolips.preferences.PreferencesPlugin;
import org.objectstyle.wolips.womodeler.server.IRequestHandler;
import org.objectstyle.wolips.womodeler.server.Webserver;

public class Request
implements Runnable {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String CONTENT_LENGTH = "content-length";
    private Webserver _server;
    private Socket _socket;
    private OutputStream _outputStream;
    private String _method;
    private String _pathAndQueryString;
    private String _path;
    private String _queryString;
    private String _content;
    private Map<String, String> _queryParameters;
    private Map<String, String> _requestHeaders;
    private Map<String, String> _responseHeaders;
    private int _responseCode;
    private ByteArrayOutputStream _responseStream;

    public Request(Webserver server, Socket socket) {
        this._server = server;
        this._socket = socket;
        this._responseStream = new ByteArrayOutputStream();
        this._responseCode = 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._responseHeaders = new HashMap<String, String>();
            InputStream is = this._socket.getInputStream();
            this._outputStream = this._socket.getOutputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String request = br.readLine();
            boolean inputDone = false;
            while (!inputDone) {
                String line = br.readLine();
                if (line == null) {
                    inputDone = true;
                    continue;
                }
                if ("".equals(line)) {
                    inputDone = true;
                    continue;
                }
                int colonIndex = line.indexOf(58);
                if (colonIndex == -1) continue;
                if (this._requestHeaders == null) {
                    this._requestHeaders = new HashMap<String, String>();
                }
                String key = line.substring(0, colonIndex).trim().toLowerCase();
                String value = line.substring(colonIndex + 1).trim().toLowerCase();
                this._requestHeaders.put(key, value);
            }
            String[] requestElements = request.split(" ");
            this._method = requestElements[0].toUpperCase();
            if (METHOD_GET.equalsIgnoreCase(this._method)) {
                this._pathAndQueryString = (requestElements[1].startsWith("/") ? "" : "/") + requestElements[1];
                this.parsePathAndQuery();
                String womodelerPassword = PreferencesPlugin.getDefault().getPreferenceStore().getString("org.objectstyle.wolips.womodeler.WOModelerServerPassword");
                if (this._queryParameters != null && womodelerPassword != null && womodelerPassword.equals(this._queryParameters.get("pw"))) {
                    IRequestHandler handler = this._server.getHandler(this);
                    if (handler != null) {
                        handler.handle(this);
                    } else {
                        this._responseCode = 404;
                    }
                } else {
                    this._responseCode = 401;
                }
            } else if (METHOD_POST.equalsIgnoreCase(this._method)) {
                StringBuffer contentBuffer = new StringBuffer();
                String contentLengthStr = this._requestHeaders.get(CONTENT_LENGTH);
                if (contentLengthStr == null) {
                    throw new IOException("Missing Content-Length header.");
                }
                int contentLength = Integer.parseInt(contentLengthStr);
                if (contentLength > 0x100000) {
                    throw new IOException("Illegal Content-Length: " + contentLength);
                }
                char[] buf = new char[2048];
                while (contentLength > 0 && br.ready()) {
                    int charsRead = br.read(buf, 0, Math.min(contentLength, buf.length));
                    if (charsRead == -1) {
                        throw new IOException("Request stopped by client.");
                    }
                    if (charsRead <= 0) continue;
                    contentLength -= charsRead;
                    contentBuffer.append(buf, 0, charsRead);
                }
                this._content = contentBuffer.toString();
                this._pathAndQueryString = (requestElements[1].startsWith("/") ? "" : "/") + requestElements[1];
                this.parsePathAndQuery();
                try {
                    IRequestHandler handler = this._server.getHandler(this);
                    handler.handle(this);
                }
                catch (FileNotFoundException e) {
                    this._responseStream.reset();
                    this._responseCode = 404;
                    this.getWriter().println("File Not Found: " + e.getMessage());
                }
            }
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(this._outputStream), true);
            pw.print("HTTP/1.1 ");
            pw.print(this._responseCode);
            pw.print(" ");
            if (this._responseCode == 200) {
                pw.println("OK");
            } else if (this._responseCode == 404) {
                pw.println("Not Found");
            } else if (this._responseCode == 401) {
                pw.println("Authorization Required");
            } else {
                pw.println("Unknown");
            }
            pw.println("Connection: close");
            for (Map.Entry<String, String> responseHeader : this._responseHeaders.entrySet()) {
                pw.println(responseHeader.getKey() + ": " + responseHeader.getValue());
            }
            pw.println();
            pw.flush();
            this._outputStream.write(this._responseStream.toByteArray(), 0, this._responseStream.size());
            this._outputStream.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                if (this._outputStream != null) {
                    this._outputStream.flush();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this._socket.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public String getMethod() {
        return this._method;
    }

    public String getPath() {
        return this._path;
    }

    public String getContent() {
        return this._content;
    }

    public void setResponseCode(int responseCode) {
        this._responseCode = responseCode;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public String getQueryString() {
        return this._queryString;
    }

    public String getPathAndQueryString() {
        return this._pathAndQueryString;
    }

    public String getQueryParameter(String name) {
        return this._queryParameters == null ? null : this._queryParameters.get(name);
    }

    public Map<String, String> getResponseHeaders() {
        return this._responseHeaders;
    }

    public Map<String, String> getQueryParameters() {
        return this._queryParameters;
    }

    public Map<String, String> getRequestHeaders() {
        return this._requestHeaders;
    }

    public String getRequestHeader(String name) {
        return this._requestHeaders == null ? null : this._requestHeaders.get(name);
    }

    public OutputStream getOutputStream() {
        return this._responseStream;
    }

    public PrintWriter getWriter() {
        return new PrintWriter((Writer)new OutputStreamWriter(this._responseStream), true);
    }

    public Webserver getServer() {
        return this._server;
    }

    protected void parsePathAndQuery() throws UnsupportedEncodingException {
        int queryStringIndex = this._pathAndQueryString.indexOf("?");
        if (queryStringIndex != -1) {
            this._queryParameters = new HashMap<String, String>();
            this._path = this._pathAndQueryString.substring(0, queryStringIndex);
            this._queryString = this._pathAndQueryString.substring(queryStringIndex + 1);
            this._queryString = this._queryString.replace("&amp;", "&");
            String[] nvPairs = this._queryString.split("&");
            for (int i = 0; i < nvPairs.length; ++i) {
                int equalsIndex = nvPairs[i].indexOf(61);
                if (equalsIndex == -1) {
                    this._queryParameters.put(URLDecoder.decode(nvPairs[i], "UTF-8"), "");
                    continue;
                }
                this._queryParameters.put(URLDecoder.decode(nvPairs[i].substring(0, equalsIndex), "UTF-8"), URLDecoder.decode(nvPairs[i].substring(equalsIndex + 1), "UTF-8"));
            }
        } else {
            this._path = this._pathAndQueryString;
            this._queryString = null;
        }
    }
}

