/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.ant.AntPlugin;
import org.objectstyle.wolips.builder.BuilderPlugin;
import org.objectstyle.wolips.builder.internal.AbstractIncrementalProjectBuilder;
import org.objectstyle.wolips.builder.internal.AntBuildMessages;
import org.objectstyle.wolips.core.resources.types.project.IProjectPatternsets;
import org.objectstyle.wolips.preferences.Preferences;

public class WOAntBuilder
extends AbstractIncrementalProjectBuilder {
    private static final int TOTAL_WORK_UNITS = 1;

    public boolean isEnabled() {
        return true;
    }

    public void invokeOldBuilder(int kind, Map args, IProgressMonitor monitor, IResourceDelta delta) {
        if (this.getProject() == null || !this.getProject().exists()) {
            monitor.done();
            return;
        }
        monitor.beginTask(AntBuildMessages.getString("Build.Monitor.Title"), 1);
        String aBuildFile = null;
        try {
            if (!this.projectNeedsAnUpdate(delta) && kind != 6) {
                monitor.done();
                return;
            }
            aBuildFile = this.buildFile();
            if (this.checkIfBuildfileExist(aBuildFile)) {
                this.getProject().getFile(aBuildFile).deleteMarkers("org.objectstyle.wolips.projectbuild.taskmarker", false, 1);
                this.execute(monitor, aBuildFile);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        aBuildFile = null;
        monitor.done();
    }

    private void execute(IProgressMonitor monitor, String aBuildFile) throws Exception {
        IProjectPatternsets project = (IProjectPatternsets)this.getProject().getAdapter(IProjectPatternsets.class);
        project.setUpPatternsetFiles();
        this.launchAntInExternalVM(this.getProject().getFile(aBuildFile), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Exception anException) {
        IMarker aMarker = null;
        try {
            if (anException == null) {
                throw new NullPointerException("WOBuilder.handleException called without an exception.");
            }
            aMarker = this.getBuildfileMarker();
            aMarker.setAttribute("message", (Object)("WOLips: " + anException.getMessage()));
        }
        catch (Exception e) {
            BuilderPlugin.getDefault().log(e);
        }
        finally {
            aMarker = null;
        }
    }

    private IMarker getBuildfileMarker() {
        IMarker aMarker = null;
        try {
            aMarker = this.getProject().getFile(this.buildFile()).createMarker("org.objectstyle.wolips.projectbuild.taskmarker");
            aMarker.setAttribute("priority", 2);
        }
        catch (CoreException e) {
            BuilderPlugin.getDefault().log(e);
        }
        return aMarker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfBuildfileExist(String aBuildFile) {
        try {
            if (this.getProject().getFile(aBuildFile).exists()) {
                return true;
            }
        }
        catch (Exception anException) {
            BuilderPlugin.getDefault().log(anException);
        }
        IMarker aMarker = null;
        try {
            aMarker = this.getProject().createMarker("org.objectstyle.wolips.projectbuild.taskmarker");
            aMarker.setAttribute("message", (Object)("WOLips: Can not find: " + this.buildFile()));
            aMarker.setAttribute("priority", 2);
        }
        catch (Exception anException) {
            BuilderPlugin.getDefault().log(anException);
        }
        finally {
            aMarker = null;
        }
        return false;
    }

    public String buildFile() {
        return "build.xml";
    }

    public String defaultTarget() {
        return null;
    }

    public String cleanTarget() {
        return "clean";
    }

    private void launchAntInExternalVM(IFile buildFile, IProgressMonitor monitor) {
        try {
            AntPlugin.getDefault().launchAntInExternalVM(buildFile, monitor, Preferences.shouldCaptureAntOutput(), null);
        }
        catch (CoreException e) {
            BuilderPlugin.getDefault().log(e);
            return;
        }
    }
}

