/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.InheritanceType;

public class SubclassOperation
extends AbstractOperation {
    private EOEntity _parentEntity;
    private EOModel _destinationModel;
    private EOEntity _subclassEntity;
    private InheritanceType _inheritanceType;
    private String _entityName;
    private String _restrictingQualifier;

    public SubclassOperation(EOEntity parentEntity, InheritanceType inheritanceType, EOModel destinationModel, String entityName, String restrictingQualifier) {
        super("Subclass " + parentEntity.getName());
        this._parentEntity = parentEntity;
        this._inheritanceType = inheritanceType;
        this._destinationModel = destinationModel;
        this._entityName = entityName;
        this._restrictingQualifier = restrictingQualifier;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            this._subclassEntity = this._parentEntity.subclass(this._entityName, this._inheritanceType);
            this._subclassEntity.setRestrictingQualifier(this._restrictingQualifier);
            this._destinationModel.addEntity(this._subclassEntity);
            return Status.OK_STATUS;
        }
        catch (EOModelException e) {
            throw new ExecutionException("Failed to subclass entity.", (Throwable)e);
        }
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
        this._subclassEntity._removeFromModelParent(failures);
        return Status.OK_STATUS;
    }
}

